/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import android.location.Location;
import android.os.Handler;
import android.os.HandlerThread;
import com.mapbox.services.android.navigation.v5.milestone.Milestone;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.navigation.NavigationRouteProcessor;
import com.mapbox.services.android.navigation.v5.navigation.RouteProcessorRunnable;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.List;

class RouteProcessorBackgroundThread
extends HandlerThread {
    private static final String MAPBOX_NAVIGATION_THREAD_NAME = "mapbox_navigation_thread";
    private final MapboxNavigation navigation;
    private final Handler responseHandler;
    private final Listener listener;
    private final NavigationRouteProcessor routeProcessor;
    private Handler workerHandler;
    private RouteProcessorRunnable runnable;

    RouteProcessorBackgroundThread(MapboxNavigation navigation, Handler responseHandler, Listener listener) {
        super(MAPBOX_NAVIGATION_THREAD_NAME, 10);
        this.navigation = navigation;
        this.responseHandler = responseHandler;
        this.listener = listener;
        this.routeProcessor = new NavigationRouteProcessor();
    }

    public synchronized void start() {
        if (super.getState() == Thread.State.NEW) {
            super.start();
            if (this.workerHandler == null) {
                this.workerHandler = new Handler(this.getLooper());
            }
            this.runnable = new RouteProcessorRunnable(this.routeProcessor, this.navigation, this.workerHandler, this.responseHandler, this.listener);
            this.workerHandler.post((Runnable)this.runnable);
        }
    }

    public boolean quit() {
        if (this.isAlive()) {
            this.workerHandler.removeCallbacks((Runnable)this.runnable);
        }
        return super.quit();
    }

    void updateLocation(Location rawLocation) {
        this.navigation.retrieveMapboxNavigator().updateLocation(rawLocation);
        if (!this.isAlive()) {
            this.start();
        }
        this.runnable.updateRawLocation(rawLocation);
    }

    static interface Listener {
        public void onNewRouteProgress(Location var1, RouteProgress var2);

        public void onMilestoneTrigger(List<Milestone> var1, RouteProgress var2);

        public void onUserOffRoute(Location var1, boolean var2);

        public void onCheckFasterRoute(Location var1, RouteProgress var2, boolean var3);
    }
}

