/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.v5.navigation;

import timber.log.Timber;

public abstract class NavigationLibraryLoader {
    private static final String NAVIGATION_NATIVE = "navigator-android";
    private static final NavigationLibraryLoader DEFAULT;
    private static volatile NavigationLibraryLoader loader;

    public static void load() {
        try {
            loader.load(NAVIGATION_NATIVE);
        }
        catch (UnsatisfiedLinkError error) {
            Timber.e((Throwable)error, (String)"Failed to load native shared library.", (Object[])new Object[0]);
        }
    }

    public abstract void load(String var1);

    static {
        loader = DEFAULT = new NavigationLibraryLoader(){

            @Override
            public void load(String name) {
                System.loadLibrary(name);
            }
        };
    }
}

