/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.voice;

import android.content.Context;
import android.os.Build;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.text.TextUtils;
import com.mapbox.services.android.navigation.ui.v5.voice.Api14UtteranceListener;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechAnnouncement;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechListener;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechPlayer;
import com.mapbox.services.android.navigation.ui.v5.voice.UtteranceListener;
import java.util.HashMap;
import java.util.Locale;
import timber.log.Timber;

class AndroidSpeechPlayer
implements SpeechPlayer {
    private static final String DEFAULT_UTTERANCE_ID = "default_id";
    private TextToSpeech textToSpeech;
    private SpeechListener speechListener;
    private boolean isMuted;
    private boolean languageSupported = false;

    AndroidSpeechPlayer(Context context, final String language, final SpeechListener speechListener) {
        this.textToSpeech = new TextToSpeech(context, new TextToSpeech.OnInitListener(){

            public void onInit(int status) {
                boolean ableToInitialize;
                boolean bl = ableToInitialize = status == 0 && language != null;
                if (!ableToInitialize) {
                    Timber.e((String)"There was an error initializing native TTS", (Object[])new Object[0]);
                    return;
                }
                AndroidSpeechPlayer.this.setSpeechListener(speechListener);
                AndroidSpeechPlayer.this.initializeWithLanguage(new Locale(language));
            }
        });
    }

    @Override
    public void play(SpeechAnnouncement speechAnnouncement) {
        boolean canPlay;
        boolean isValidAnnouncement = speechAnnouncement != null && !TextUtils.isEmpty((CharSequence)speechAnnouncement.announcement());
        boolean bl = canPlay = isValidAnnouncement && this.languageSupported && !this.isMuted;
        if (!canPlay) {
            return;
        }
        this.fireInstructionListenerIfApi14();
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("utteranceId", DEFAULT_UTTERANCE_ID);
        this.textToSpeech.speak(speechAnnouncement.announcement(), 1, params);
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    @Override
    public void setMuted(boolean isMuted) {
        this.isMuted = isMuted;
        if (isMuted) {
            this.muteTts();
        }
    }

    @Override
    public void onOffRoute() {
        this.muteTts();
    }

    @Override
    public void onDestroy() {
        if (this.textToSpeech != null) {
            this.textToSpeech.stop();
            this.textToSpeech.shutdown();
        }
    }

    private void muteTts() {
        if (this.textToSpeech.isSpeaking()) {
            this.textToSpeech.stop();
        }
    }

    private void initializeWithLanguage(Locale language) {
        boolean isLanguageAvailable;
        boolean bl = isLanguageAvailable = this.textToSpeech.isLanguageAvailable(language) == 0;
        if (!isLanguageAvailable) {
            Timber.w((String)"The specified language is not supported by TTS", (Object[])new Object[0]);
            return;
        }
        this.languageSupported = true;
        this.textToSpeech.setLanguage(language);
    }

    private void fireInstructionListenerIfApi14() {
        if (Build.VERSION.SDK_INT < 15) {
            this.speechListener.onStart();
        }
    }

    private void setSpeechListener(SpeechListener speechListener) {
        this.speechListener = speechListener;
        if (Build.VERSION.SDK_INT < 15) {
            this.textToSpeech.setOnUtteranceCompletedListener((TextToSpeech.OnUtteranceCompletedListener)new Api14UtteranceListener(speechListener));
        } else {
            this.textToSpeech.setOnUtteranceProgressListener((UtteranceProgressListener)new UtteranceListener(speechListener));
        }
    }
}

