/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.summary;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.format.DateFormat;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.services.android.navigation.v5.utils.DistanceFormatter;
import com.mapbox.services.android.navigation.v5.utils.time.TimeFormatter;
import java.util.Calendar;

public class SummaryModel {
    private final String distanceRemaining;
    private final SpannableStringBuilder timeRemaining;
    private final String arrivalTime;

    public SummaryModel(Context context, DistanceFormatter distanceFormatter, RouteProgress progress, int timeFormatType) {
        this.distanceRemaining = distanceFormatter.formatDistance(progress.distanceRemaining()).toString();
        double legDurationRemaining = progress.currentLegProgress().durationRemaining();
        this.timeRemaining = TimeFormatter.formatTimeRemaining((Context)context, (double)legDurationRemaining);
        Calendar time = Calendar.getInstance();
        boolean isTwentyFourHourFormat = DateFormat.is24HourFormat((Context)context);
        this.arrivalTime = TimeFormatter.formatTime((Calendar)time, (double)legDurationRemaining, (int)timeFormatType, (boolean)isTwentyFourHourFormat);
    }

    String getDistanceRemaining() {
        return this.distanceRemaining;
    }

    SpannableStringBuilder getTimeRemaining() {
        return this.timeRemaining;
    }

    String getArrivalTime() {
        return this.arrivalTime;
    }
}

