/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.route;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.StyleRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.content.res.AppCompatResources;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.MathUtils;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.route.RouteConstants;
import com.mapbox.services.android.navigation.ui.v5.utils.MapImageUtils;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import com.mapbox.turf.TurfMeasurement;
import com.mapbox.turf.TurfMisc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class MapRouteArrow {
    @ColorInt
    private final int arrowColor;
    @ColorInt
    private final int arrowBorderColor;
    private List<Layer> arrowLayers;
    private GeoJsonSource arrowShaftGeoJsonSource;
    private GeoJsonSource arrowHeadGeoJsonSource;
    private final MapView mapView;
    private final MapboxMap mapboxMap;

    MapRouteArrow(MapView mapView, MapboxMap mapboxMap, @StyleRes int styleRes) {
        this.mapView = mapView;
        this.mapboxMap = mapboxMap;
        Context context = mapView.getContext();
        TypedArray typedArray = context.obtainStyledAttributes(styleRes, R.styleable.NavigationMapRoute);
        this.arrowColor = typedArray.getColor(R.styleable.NavigationMapRoute_upcomingManeuverArrowColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_upcoming_maneuver_arrow_color));
        this.arrowBorderColor = typedArray.getColor(R.styleable.NavigationMapRoute_upcomingManeuverArrowBorderColor, ContextCompat.getColor((Context)context, (int)R.color.mapbox_navigation_route_upcoming_maneuver_arrow_border_color));
        typedArray.recycle();
        this.initialize();
    }

    void addUpcomingManeuverArrow(RouteProgress routeProgress) {
        boolean invalidCurrentStepPoints;
        boolean invalidUpcomingStepPoints = routeProgress.upcomingStepPoints() == null || routeProgress.upcomingStepPoints().size() < 2;
        boolean bl = invalidCurrentStepPoints = routeProgress.currentStepPoints().size() < 2;
        if (invalidUpcomingStepPoints || invalidCurrentStepPoints) {
            this.updateVisibilityTo(false);
            return;
        }
        this.updateVisibilityTo(true);
        List<Point> maneuverPoints = this.obtainArrowPointsFrom(routeProgress);
        this.updateArrowShaftWith(maneuverPoints);
        this.updateArrowHeadWith(maneuverPoints);
    }

    void updateVisibilityTo(boolean visible) {
        Iterator<Layer> iterator = this.arrowLayers.iterator();
        while (iterator.hasNext()) {
            Layer layer;
            String targetVisibility = visible ? "visible" : "none";
            if (targetVisibility.equals((layer = iterator.next()).getVisibility().getValue())) continue;
            layer.setProperties(new PropertyValue[]{PropertyFactory.visibility((String)targetVisibility)});
        }
    }

    private List<Point> obtainArrowPointsFrom(RouteProgress routeProgress) {
        ArrayList reversedCurrent = new ArrayList(routeProgress.currentStepPoints());
        Collections.reverse(reversedCurrent);
        LineString arrowLineCurrent = LineString.fromLngLats(reversedCurrent);
        LineString arrowLineUpcoming = LineString.fromLngLats((List)routeProgress.upcomingStepPoints());
        LineString arrowCurrentSliced = TurfMisc.lineSliceAlong((LineString)arrowLineCurrent, (double)0.0, (double)30.0, (String)"meters");
        LineString arrowUpcomingSliced = TurfMisc.lineSliceAlong((LineString)arrowLineUpcoming, (double)0.0, (double)30.0, (String)"meters");
        Collections.reverse(arrowCurrentSliced.coordinates());
        ArrayList<Point> combined = new ArrayList<Point>();
        combined.addAll(arrowCurrentSliced.coordinates());
        combined.addAll(arrowUpcomingSliced.coordinates());
        return combined;
    }

    private void updateArrowShaftWith(List<Point> points) {
        LineString shaft = LineString.fromLngLats(points);
        Feature arrowShaftGeoJsonFeature = Feature.fromGeometry((Geometry)shaft);
        this.arrowShaftGeoJsonSource.setGeoJson(arrowShaftGeoJsonFeature);
    }

    private void updateArrowHeadWith(List<Point> points) {
        double azimuth = TurfMeasurement.bearing((Point)points.get(points.size() - 2), (Point)points.get(points.size() - 1));
        Feature arrowHeadGeoJsonFeature = Feature.fromGeometry((Geometry)((Geometry)points.get(points.size() - 1)));
        arrowHeadGeoJsonFeature.addNumberProperty("mapbox-navigation-arrow-bearing", (Number)Float.valueOf((float)MathUtils.wrap((double)azimuth, (double)0.0, (double)360.0)));
        this.arrowHeadGeoJsonSource.setGeoJson(arrowHeadGeoJsonFeature);
    }

    private void initialize() {
        this.initializeArrowShaft();
        this.initializeArrowHead();
        this.addArrowHeadIcon();
        this.addArrowHeadIconCasing();
        LineLayer shaftLayer = this.createArrowShaftLayer();
        LineLayer shaftCasingLayer = this.createArrowShaftCasingLayer();
        SymbolLayer headLayer = this.createArrowHeadLayer();
        SymbolLayer headCasingLayer = this.createArrowHeadCasingLayer();
        this.mapboxMap.getStyle().addLayerBelow((Layer)shaftCasingLayer, "com.mapbox.annotations.points");
        this.mapboxMap.getStyle().addLayerAbove((Layer)headCasingLayer, shaftCasingLayer.getId());
        this.mapboxMap.getStyle().addLayerAbove((Layer)shaftLayer, headCasingLayer.getId());
        this.mapboxMap.getStyle().addLayerAbove((Layer)headLayer, shaftLayer.getId());
        this.createArrowLayerList(shaftLayer, shaftCasingLayer, headLayer, headCasingLayer);
    }

    private void initializeArrowShaft() {
        this.arrowShaftGeoJsonSource = new GeoJsonSource("mapbox-navigation-arrow-shaft-source", FeatureCollection.fromFeatures((Feature[])new Feature[0]), new GeoJsonOptions().withMaxZoom(16));
        this.mapboxMap.getStyle().addSource((Source)this.arrowShaftGeoJsonSource);
    }

    private void initializeArrowHead() {
        this.arrowHeadGeoJsonSource = new GeoJsonSource("mapbox-navigation-arrow-head-source", FeatureCollection.fromFeatures((Feature[])new Feature[0]), new GeoJsonOptions().withMaxZoom(16));
        this.mapboxMap.getStyle().addSource((Source)this.arrowHeadGeoJsonSource);
    }

    private void addArrowHeadIcon() {
        int headResId = R.drawable.ic_arrow_head;
        Drawable arrowHead = AppCompatResources.getDrawable((Context)this.mapView.getContext(), (int)headResId);
        if (arrowHead == null) {
            return;
        }
        Drawable head = DrawableCompat.wrap((Drawable)arrowHead);
        DrawableCompat.setTint((Drawable)head.mutate(), (int)this.arrowColor);
        Bitmap icon = MapImageUtils.getBitmapFromDrawable(head);
        this.mapboxMap.getStyle().addImage("mapbox-navigation-arrow-head-icon", icon);
    }

    private void addArrowHeadIconCasing() {
        int casingResId = R.drawable.ic_arrow_head_casing;
        Drawable arrowHeadCasing = AppCompatResources.getDrawable((Context)this.mapView.getContext(), (int)casingResId);
        if (arrowHeadCasing == null) {
            return;
        }
        Drawable headCasing = DrawableCompat.wrap((Drawable)arrowHeadCasing);
        DrawableCompat.setTint((Drawable)headCasing.mutate(), (int)this.arrowBorderColor);
        Bitmap icon = MapImageUtils.getBitmapFromDrawable(headCasing);
        this.mapboxMap.getStyle().addImage("mapbox-navigation-arrow-head-icon-casing", icon);
    }

    private LineLayer createArrowShaftLayer() {
        LineLayer shaftLayer = (LineLayer)this.mapboxMap.getStyle().getLayer("mapbox-navigation-arrow-shaft-layer");
        if (shaftLayer != null) {
            this.mapboxMap.getStyle().removeLayer((Layer)shaftLayer);
        }
        return new LineLayer("mapbox-navigation-arrow-shaft-layer", "mapbox-navigation-arrow-shaft-source").withProperties(new PropertyValue[]{PropertyFactory.lineColor((Expression)Expression.color((int)this.arrowColor)), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.linear(), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)10, (Object)Float.valueOf(2.6f)), Expression.stop((Object)22, (Object)Float.valueOf(13.0f))})), PropertyFactory.lineCap((String)"round"), PropertyFactory.lineJoin((String)"round"), PropertyFactory.visibility((String)"none"), PropertyFactory.lineOpacity((Expression)Expression.step((Expression)Expression.zoom(), (Number)Float.valueOf(0.0f), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)14, (Object)Float.valueOf(1.0f))}))});
    }

    private LineLayer createArrowShaftCasingLayer() {
        LineLayer shaftCasingLayer = (LineLayer)this.mapboxMap.getStyle().getLayer("mapbox-navigation-arrow-shaft-casing-layer");
        if (shaftCasingLayer != null) {
            this.mapboxMap.getStyle().removeLayer((Layer)shaftCasingLayer);
        }
        return new LineLayer("mapbox-navigation-arrow-shaft-casing-layer", "mapbox-navigation-arrow-shaft-source").withProperties(new PropertyValue[]{PropertyFactory.lineColor((Expression)Expression.color((int)this.arrowBorderColor)), PropertyFactory.lineWidth((Expression)Expression.interpolate((Expression.Interpolator)Expression.linear(), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)10, (Object)Float.valueOf(3.4f)), Expression.stop((Object)22, (Object)Float.valueOf(17.0f))})), PropertyFactory.lineCap((String)"round"), PropertyFactory.lineJoin((String)"round"), PropertyFactory.visibility((String)"none"), PropertyFactory.lineOpacity((Expression)Expression.step((Expression)Expression.zoom(), (Number)Float.valueOf(0.0f), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)14, (Object)Float.valueOf(1.0f))}))});
    }

    private SymbolLayer createArrowHeadLayer() {
        SymbolLayer headLayer = (SymbolLayer)this.mapboxMap.getStyle().getLayer("mapbox-navigation-arrow-head-layer");
        if (headLayer != null) {
            this.mapboxMap.getStyle().removeLayer((Layer)headLayer);
        }
        return new SymbolLayer("mapbox-navigation-arrow-head-layer", "mapbox-navigation-arrow-head-source").withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"mapbox-navigation-arrow-head-icon"), PropertyFactory.iconAllowOverlap((Boolean)true), PropertyFactory.iconIgnorePlacement((Boolean)true), PropertyFactory.iconSize((Expression)Expression.interpolate((Expression.Interpolator)Expression.linear(), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)10, (Object)Float.valueOf(0.2f)), Expression.stop((Object)22, (Object)Float.valueOf(0.8f))})), PropertyFactory.iconOffset((Float[])RouteConstants.ARROW_HEAD_OFFSET), PropertyFactory.iconRotationAlignment((String)"map"), PropertyFactory.iconRotate((Expression)Expression.get((String)"mapbox-navigation-arrow-bearing")), PropertyFactory.visibility((String)"none"), PropertyFactory.iconOpacity((Expression)Expression.step((Expression)Expression.zoom(), (Number)Float.valueOf(0.0f), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)14, (Object)Float.valueOf(1.0f))}))});
    }

    private SymbolLayer createArrowHeadCasingLayer() {
        SymbolLayer headCasingLayer = (SymbolLayer)this.mapboxMap.getStyle().getLayer("mapbox-navigation-arrow-head-casing-layer");
        if (headCasingLayer != null) {
            this.mapboxMap.getStyle().removeLayer((Layer)headCasingLayer);
        }
        return new SymbolLayer("mapbox-navigation-arrow-head-casing-layer", "mapbox-navigation-arrow-head-source").withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"mapbox-navigation-arrow-head-icon-casing"), PropertyFactory.iconAllowOverlap((Boolean)true), PropertyFactory.iconIgnorePlacement((Boolean)true), PropertyFactory.iconSize((Expression)Expression.interpolate((Expression.Interpolator)Expression.linear(), (Expression)Expression.zoom(), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)10, (Object)Float.valueOf(0.2f)), Expression.stop((Object)22, (Object)Float.valueOf(0.8f))})), PropertyFactory.iconOffset((Float[])RouteConstants.ARROW_HEAD_CASING_OFFSET), PropertyFactory.iconRotationAlignment((String)"map"), PropertyFactory.iconRotate((Expression)Expression.get((String)"mapbox-navigation-arrow-bearing")), PropertyFactory.visibility((String)"none"), PropertyFactory.iconOpacity((Expression)Expression.step((Expression)Expression.zoom(), (Number)Float.valueOf(0.0f), (Expression.Stop[])new Expression.Stop[]{Expression.stop((Object)14, (Object)Float.valueOf(1.0f))}))});
    }

    private void createArrowLayerList(LineLayer shaftLayer, LineLayer shaftCasingLayer, SymbolLayer headLayer, SymbolLayer headCasingLayer) {
        this.arrowLayers = new ArrayList<Layer>();
        this.arrowLayers.add((Layer)shaftCasingLayer);
        this.arrowLayers.add((Layer)shaftLayer);
        this.arrowLayers.add((Layer)headCasingLayer);
        this.arrowLayers.add((Layer)headLayer);
    }
}

