/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.map;

import android.graphics.PointF;
import android.location.Location;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.ui.v5.map.FeatureFilterTask;
import com.mapbox.services.android.navigation.ui.v5.map.MapPaddingAdjustor;
import com.mapbox.services.android.navigation.ui.v5.map.MapWaynameProgressChangeListener;
import com.mapbox.services.android.navigation.ui.v5.map.OnFeatureFilteredCallback;
import com.mapbox.services.android.navigation.ui.v5.map.OnWayNameChangedListener;
import com.mapbox.services.android.navigation.ui.v5.map.WaynameFeatureFinder;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class MapWayName {
    private static final String NAME_PROPERTY = "name";
    private static final String EMPTY_CURRENT_WAY_NAME = "";
    private final MapWaynameProgressChangeListener progressChangeListener = new MapWaynameProgressChangeListener(this);
    private final Set<OnWayNameChangedListener> onWayNameChangedListeners;
    private WaynameFeatureFinder featureInteractor;
    private List<Point> currentStepPoints = new ArrayList<Point>();
    private Location currentLocation = null;
    private MapboxNavigation navigation;
    private boolean isAutoQueryEnabled;
    private FeatureFilterTask filterTask;
    private String wayName = "";

    MapWayName(WaynameFeatureFinder featureInteractor, MapPaddingAdjustor paddingAdjustor) {
        this.featureInteractor = featureInteractor;
        paddingAdjustor.updatePaddingWithDefault();
        this.onWayNameChangedListeners = new HashSet<OnWayNameChangedListener>();
    }

    void updateWayNameWithPoint(PointF point) {
        if (!this.isAutoQueryEnabled) {
            return;
        }
        List<Feature> roadLabelFeatures = this.findRoadLabelFeatures(point);
        boolean invalidLabelFeatures = roadLabelFeatures.isEmpty();
        if (invalidLabelFeatures) {
            return;
        }
        this.executeFeatureFilterTask(roadLabelFeatures);
    }

    void updateProgress(Location currentLocation, List<Point> currentStepPoints) {
        if (!this.currentStepPoints.equals(currentStepPoints)) {
            this.currentStepPoints = currentStepPoints;
        }
        if (this.currentLocation == null || !this.currentLocation.equals(currentLocation)) {
            this.currentLocation = currentLocation;
        }
    }

    void updateWayNameQueryMap(boolean isEnabled) {
        this.isAutoQueryEnabled = isEnabled;
    }

    void addProgressChangeListener(MapboxNavigation navigation) {
        this.navigation = navigation;
        navigation.addProgressChangeListener((ProgressChangeListener)this.progressChangeListener);
    }

    boolean addOnWayNameChangedListener(OnWayNameChangedListener listener) {
        return this.onWayNameChangedListeners.add(listener);
    }

    boolean removeOnWayNameChangedListener(OnWayNameChangedListener listener) {
        return this.onWayNameChangedListeners.remove(listener);
    }

    void onStart() {
        if (this.navigation != null) {
            this.navigation.addProgressChangeListener((ProgressChangeListener)this.progressChangeListener);
        }
    }

    void onStop() {
        if (this.isTaskRunning()) {
            this.filterTask.cancel(true);
        }
        if (this.navigation != null) {
            this.navigation.removeProgressChangeListener((ProgressChangeListener)this.progressChangeListener);
        }
    }

    private List<Feature> findRoadLabelFeatures(PointF point) {
        String[] layerIds = new String[]{"streetsLayer"};
        return this.featureInteractor.queryRenderedFeatures(point, layerIds);
    }

    private void executeFeatureFilterTask(List<Feature> roadFeatures) {
        if (this.isTaskRunning()) {
            this.filterTask.cancel(true);
        }
        if (this.hasValidProgressData()) {
            this.filterTask = new FeatureFilterTask(roadFeatures, this.currentLocation, this.currentStepPoints, new OnFeatureFilteredCallback(){

                @Override
                public void onFeatureFiltered(@NonNull Feature feature) {
                    MapWayName.this.updateWayNameLayerWithNameProperty(feature);
                }
            });
            this.filterTask.execute(new Void[0]);
        }
    }

    private boolean isTaskRunning() {
        return this.filterTask != null && (this.filterTask.getStatus() == AsyncTask.Status.PENDING || this.filterTask.getStatus() == AsyncTask.Status.RUNNING);
    }

    private boolean hasValidProgressData() {
        return this.currentLocation != null && !this.currentStepPoints.isEmpty();
    }

    private void updateWayNameLayerWithNameProperty(Feature roadFeature) {
        boolean hasValidNameProperty = roadFeature.hasNonNullValueForProperty(NAME_PROPERTY);
        if (hasValidNameProperty) {
            boolean newWayName;
            String currentWayName = roadFeature.getStringProperty(NAME_PROPERTY);
            boolean bl = newWayName = !this.wayName.contentEquals(currentWayName);
            if (newWayName) {
                this.updateListenersWith(currentWayName);
                this.wayName = currentWayName;
            }
        } else {
            this.updateListenersWith(EMPTY_CURRENT_WAY_NAME);
        }
    }

    private void updateListenersWith(String currentWayName) {
        for (OnWayNameChangedListener listener : this.onWayNameChangedListeners) {
            listener.onWayNameChanged(currentWayName);
        }
    }
}

