/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.instruction;

import android.support.annotation.NonNull;
import android.widget.TextView;
import com.mapbox.api.directions.v5.models.BannerComponents;
import com.mapbox.api.directions.v5.models.BannerText;
import com.mapbox.services.android.navigation.ui.v5.instruction.BannerComponentNode;
import com.mapbox.services.android.navigation.ui.v5.instruction.NodeCreator;
import java.util.ArrayList;
import java.util.List;

class BannerComponentTree {
    private final NodeCreator[] nodeCreators;
    private final List<BannerComponentNode> bannerComponentNodes;

    BannerComponentTree(@NonNull BannerText bannerText, NodeCreator ... nodeCreators) {
        this.nodeCreators = nodeCreators;
        this.bannerComponentNodes = this.parseBannerComponents(bannerText);
    }

    private List<BannerComponentNode> parseBannerComponents(BannerText bannerText) {
        int length = 0;
        ArrayList<BannerComponentNode> bannerComponentNodes = new ArrayList<BannerComponentNode>();
        for (BannerComponents components : bannerText.components()) {
            Object node = null;
            for (NodeCreator nodeCreator : this.nodeCreators) {
                if (!nodeCreator.isNodeType(components)) continue;
                node = nodeCreator.setupNode(components, bannerComponentNodes.size(), length, bannerText.modifier());
                break;
            }
            if (node == null) continue;
            bannerComponentNodes.add((BannerComponentNode)node);
            length += components.text().length();
        }
        return bannerComponentNodes;
    }

    void loadInstruction(TextView textView) {
        for (NodeCreator nodeCreator : this.nodeCreators) {
            nodeCreator.preProcess(textView, this.bannerComponentNodes);
        }
        for (NodeCreator nodeCreator : this.nodeCreators) {
            nodeCreator.postProcess(textView, this.bannerComponentNodes);
        }
    }
}

