/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.feedback;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

public class FeedbackClickListener
implements RecyclerView.OnItemTouchListener {
    private GestureDetector gestureDetector;
    private ClickCallback callback;

    FeedbackClickListener(Context context, ClickCallback callback) {
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new ResultGestureListener());
        this.callback = callback;
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent motionEvent) {
        View child = rv.findChildViewUnder(motionEvent.getX(), motionEvent.getY());
        if (child != null && this.gestureDetector.onTouchEvent(motionEvent)) {
            child.playSoundEffect(0);
            int position = rv.getChildAdapterPosition(child);
            this.callback.onFeedbackItemClick(position);
        }
        return false;
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent motionEvent) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public static interface ClickCallback {
        public void onFeedbackItemClick(int var1);
    }

    private static class ResultGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private ResultGestureListener() {
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return true;
        }
    }
}

