/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.feedback;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackItem;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackViewHolder;
import java.util.ArrayList;
import java.util.List;

public class FeedbackAdapter
extends RecyclerView.Adapter<FeedbackViewHolder> {
    private static final String EMPTY_FEEDBACK_DESCRIPTION = "";
    private List<FeedbackItem> feedbackItems = new ArrayList<FeedbackItem>();

    FeedbackAdapter(Context context) {
        this.feedbackItems.add(new FeedbackItem(context.getString(R.string.feedback_not_allowed), R.drawable.ic_no_turn_allowed, "not_allowed", EMPTY_FEEDBACK_DESCRIPTION));
        this.feedbackItems.add(new FeedbackItem(context.getString(R.string.feedback_road_closure), R.drawable.ic_road_closed, "road_closed", EMPTY_FEEDBACK_DESCRIPTION));
        this.feedbackItems.add(new FeedbackItem(context.getString(R.string.feedback_report_traffic), R.drawable.ic_traffic, "report_traffic", EMPTY_FEEDBACK_DESCRIPTION));
        this.feedbackItems.add(new FeedbackItem(context.getString(R.string.feedback_confusing_instruction), R.drawable.ic_confusing_directions, "confusing_instruction", EMPTY_FEEDBACK_DESCRIPTION));
        this.feedbackItems.add(new FeedbackItem(context.getString(R.string.feedback_general_issue), R.drawable.ic_map_error, "other_map_issue", EMPTY_FEEDBACK_DESCRIPTION));
        this.feedbackItems.add(new FeedbackItem(context.getString(R.string.feedback_bad_route), R.drawable.ic_wrong_directions, "routing_error", EMPTY_FEEDBACK_DESCRIPTION));
    }

    public FeedbackViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.feedback_viewholder_layout, parent, false);
        return new FeedbackViewHolder(view);
    }

    public void onBindViewHolder(FeedbackViewHolder viewHolder, int position) {
        viewHolder.setFeedbackImage(this.feedbackItems.get(position).getFeedbackImageId());
        viewHolder.setFeedbackText(this.feedbackItems.get(position).getFeedbackText());
    }

    public int getItemCount() {
        return this.feedbackItems.size();
    }

    FeedbackItem getFeedbackItem(int feedbackPosition) {
        if (feedbackPosition < this.feedbackItems.size()) {
            return this.feedbackItems.get(feedbackPosition);
        }
        return null;
    }
}

