/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.camera;

import android.location.Location;
import android.support.annotation.NonNull;
import com.mapbox.api.directions.v5.models.LegStep;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.services.android.navigation.v5.navigation.camera.RouteInformation;
import com.mapbox.services.android.navigation.v5.navigation.camera.SimpleCamera;
import com.mapbox.services.android.navigation.v5.routeprogress.RouteProgress;
import java.util.ArrayList;

public class DynamicCamera
extends SimpleCamera {
    private static final double MAX_CAMERA_TILT = 60.0;
    private static final double MIN_CAMERA_TILT = 45.0;
    private static final double MAX_CAMERA_ZOOM = 16.0;
    private static final double MIN_CAMERA_ZOOM = 12.0;
    private MapboxMap mapboxMap;
    private LegStep currentStep;
    private boolean hasPassedLowAlertLevel;
    private boolean hasPassedMediumAlertLevel;
    private boolean hasPassedHighAlertLevel;
    private boolean forceUpdateZoom;
    private boolean isShutdown = false;

    public DynamicCamera(@NonNull MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    public double tilt(RouteInformation routeInformation) {
        if (this.isShutdown) {
            return 50.0;
        }
        RouteProgress progress = routeInformation.routeProgress();
        if (progress != null) {
            double distanceRemaining = progress.currentLegProgress().currentStepProgress().distanceRemaining();
            return this.createTilt(distanceRemaining);
        }
        return super.tilt(routeInformation);
    }

    public double zoom(RouteInformation routeInformation) {
        if (this.isShutdown) {
            return 15.0;
        }
        if (this.validLocationAndProgress(routeInformation) && this.shouldUpdateZoom(routeInformation)) {
            return this.createZoom(routeInformation);
        }
        if (routeInformation.route() != null) {
            return super.zoom(routeInformation);
        }
        return this.mapboxMap.getCameraPosition().zoom;
    }

    public void forceResetZoomLevel() {
        this.forceUpdateZoom = true;
    }

    public void clearMap() {
        this.isShutdown = true;
        this.mapboxMap = null;
    }

    private double createTilt(double distanceRemaining) {
        double tilt = distanceRemaining / 5.0;
        if (tilt > 60.0) {
            return 60.0;
        }
        if (tilt < 45.0) {
            return 45.0;
        }
        return Math.round(tilt);
    }

    private double createZoom(RouteInformation routeInformation) {
        CameraPosition position = this.createCameraPosition(routeInformation.location(), routeInformation.routeProgress());
        if (position.zoom > 16.0) {
            return 16.0;
        }
        if (position.zoom < 12.0) {
            return 12.0;
        }
        return position.zoom;
    }

    private CameraPosition createCameraPosition(Location location, RouteProgress routeProgress) {
        LegStep upComingStep = routeProgress.currentLegProgress().upComingStep();
        if (upComingStep != null) {
            Point stepManeuverPoint = upComingStep.maneuver().location();
            ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
            LatLng currentLatLng = new LatLng(location);
            LatLng maneuverLatLng = new LatLng(stepManeuverPoint.latitude(), stepManeuverPoint.longitude());
            latLngs.add(currentLatLng);
            latLngs.add(maneuverLatLng);
            if (latLngs.size() < 1 || currentLatLng.equals((Object)maneuverLatLng)) {
                return this.mapboxMap.getCameraPosition();
            }
            LatLngBounds cameraBounds = new LatLngBounds.Builder().includes(latLngs).build();
            int[] padding = new int[]{0, 0, 0, 0};
            return this.mapboxMap.getCameraForLatLngBounds(cameraBounds, padding);
        }
        return this.mapboxMap.getCameraPosition();
    }

    private boolean isForceUpdate() {
        if (this.forceUpdateZoom) {
            this.forceUpdateZoom = false;
            return true;
        }
        return false;
    }

    private boolean isNewStep(RouteProgress routeProgress) {
        boolean isNewStep = this.currentStep == null || !this.currentStep.equals(routeProgress.currentLegProgress().currentStep());
        this.currentStep = routeProgress.currentLegProgress().currentStep();
        this.resetAlertLevels(isNewStep);
        return isNewStep;
    }

    private void resetAlertLevels(boolean isNewStep) {
        if (isNewStep) {
            this.hasPassedLowAlertLevel = false;
            this.hasPassedMediumAlertLevel = false;
            this.hasPassedHighAlertLevel = false;
        }
    }

    private boolean validLocationAndProgress(RouteInformation routeInformation) {
        return routeInformation.location() != null && routeInformation.routeProgress() != null;
    }

    private boolean shouldUpdateZoom(RouteInformation routeInformation) {
        RouteProgress progress = routeInformation.routeProgress();
        return this.isForceUpdate() || this.isNewStep(progress) || this.isLowAlert(progress) || this.isMediumAlert(progress) || this.isHighAlert(progress);
    }

    private boolean isLowAlert(RouteProgress progress) {
        if (!this.hasPassedLowAlertLevel) {
            boolean hasValidStepDuration;
            double durationRemaining = progress.currentLegProgress().currentStepProgress().durationRemaining();
            double stepDuration = progress.currentLegProgress().currentStep().duration();
            boolean isLowAlert = durationRemaining < 125.0;
            boolean bl = hasValidStepDuration = stepDuration > 125.0;
            if (hasValidStepDuration && isLowAlert) {
                this.hasPassedLowAlertLevel = true;
                return true;
            }
        }
        return false;
    }

    private boolean isMediumAlert(RouteProgress progress) {
        if (!this.hasPassedMediumAlertLevel) {
            boolean hasValidStepDuration;
            double durationRemaining = progress.currentLegProgress().currentStepProgress().durationRemaining();
            double stepDuration = progress.currentLegProgress().currentStep().duration();
            boolean isMediumAlert = durationRemaining < 70.0;
            boolean bl = hasValidStepDuration = stepDuration > 70.0;
            if (hasValidStepDuration && isMediumAlert) {
                this.hasPassedMediumAlertLevel = true;
                return true;
            }
        }
        return false;
    }

    private boolean isHighAlert(RouteProgress progress) {
        if (!this.hasPassedHighAlertLevel) {
            boolean hasValidStepDuration;
            double durationRemaining = progress.currentLegProgress().currentStepProgress().durationRemaining();
            double stepDuration = progress.currentLegProgress().currentStep().duration();
            boolean isHighAlert = durationRemaining < 15.0;
            boolean bl = hasValidStepDuration = stepDuration > 15.0;
            if (hasValidStepDuration && isHighAlert) {
                this.hasPassedHighAlertLevel = true;
                return true;
            }
        }
        return false;
    }
}

