/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5.alert;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.ThemeSwitcher;
import com.mapbox.services.android.navigation.ui.v5.alert.AlertViewAnimatorListener;

public class AlertView
extends CardView {
    private static final String ALERT_VIEW_PROGRESS = "progress";
    private TextView alertText;
    private ProgressBar alertProgressBar;
    private Animation fadeOut;
    private Animation slideDownTop;

    public AlertView(Context context) {
        this(context, null);
    }

    public AlertView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public AlertView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bind();
        this.initAnimations();
        this.initBackground();
    }

    public void show(String alertText, long duration, boolean showLoading) {
        this.alertText.setText((CharSequence)alertText);
        this.alertProgressBar.setProgress(this.alertProgressBar.getMax());
        if (this.getVisibility() == 4) {
            this.setVisibility(0);
            this.startAnimation(this.slideDownTop);
            if (duration > 0L) {
                this.startCountdown(duration);
            }
            this.showLoading(showLoading);
        }
    }

    public void hide() {
        if (this.getVisibility() == 0) {
            this.startAnimation(this.fadeOut);
            this.setVisibility(4);
        }
    }

    public String getAlertText() {
        return this.alertText.getText().toString();
    }

    private void init() {
        AlertView.inflate((Context)this.getContext(), (int)R.layout.alert_view_layout, (ViewGroup)this);
    }

    private void bind() {
        this.alertText = (TextView)this.findViewById(R.id.alertText);
        this.alertProgressBar = (ProgressBar)this.findViewById(R.id.alertProgressBar);
    }

    private void initAnimations() {
        this.fadeOut = new AlphaAnimation(1.0f, 0.0f);
        this.fadeOut.setInterpolator((Interpolator)new AccelerateInterpolator());
        this.fadeOut.setDuration(300L);
        this.slideDownTop = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_down_top);
        this.slideDownTop.setInterpolator((Interpolator)new OvershootInterpolator(2.0f));
    }

    private void initBackground() {
        if (Build.VERSION.SDK_INT < 21) {
            int progressColor = ThemeSwitcher.retrieveThemeColor(this.getContext(), R.attr.navigationViewProgress);
            int progressBackgroundColor = ThemeSwitcher.retrieveThemeColor(this.getContext(), R.attr.navigationViewProgressBackground);
            LayerDrawable progressBarDrawable = (LayerDrawable)this.alertProgressBar.getProgressDrawable();
            Drawable progressBackgroundDrawable = progressBarDrawable.getDrawable(0);
            progressBackgroundDrawable.setColorFilter(progressBackgroundColor, PorterDuff.Mode.SRC_IN);
            Drawable progressDrawable = progressBarDrawable.getDrawable(1);
            progressDrawable.setColorFilter(progressColor, PorterDuff.Mode.SRC_IN);
            this.getBackground().setAlpha(0);
        } else {
            this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170445));
        }
    }

    private void startCountdown(long duration) {
        ObjectAnimator countdownAnimation = ObjectAnimator.ofInt((Object)this.alertProgressBar, (String)ALERT_VIEW_PROGRESS, (int[])new int[]{0});
        countdownAnimation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        countdownAnimation.setDuration(duration);
        countdownAnimation.addListener((Animator.AnimatorListener)new AlertViewAnimatorListener(this));
        countdownAnimation.start();
    }

    private void showLoading(boolean showLoading) {
        this.alertProgressBar.setVisibility(showLoading ? 0 : 4);
    }
}

