/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.location.Location;
import android.support.annotation.Nullable;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.ui.v5.NavigationPresenter;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewModel;

class NavigationViewSubscriber {
    private NavigationPresenter navigationPresenter;

    NavigationViewSubscriber(NavigationPresenter navigationPresenter) {
        this.navigationPresenter = navigationPresenter;
    }

    void subscribe(LifecycleOwner owner, NavigationViewModel navigationViewModel) {
        navigationViewModel.route.observe(owner, (Observer)new Observer<DirectionsRoute>(){

            public void onChanged(@Nullable DirectionsRoute directionsRoute) {
                if (directionsRoute != null) {
                    NavigationViewSubscriber.this.navigationPresenter.onRouteUpdate(directionsRoute);
                }
            }
        });
        navigationViewModel.retrieveDestination().observe(owner, (Observer)new Observer<Point>(){

            public void onChanged(@Nullable Point point) {
                if (point != null) {
                    NavigationViewSubscriber.this.navigationPresenter.onDestinationUpdate(point);
                }
            }
        });
        navigationViewModel.navigationLocation.observe(owner, (Observer)new Observer<Location>(){

            public void onChanged(@Nullable Location location) {
                if (location != null) {
                    NavigationViewSubscriber.this.navigationPresenter.onNavigationLocationUpdate(location);
                }
            }
        });
        navigationViewModel.shouldRecordScreenshot.observe(owner, (Observer)new Observer<Boolean>(){

            public void onChanged(@Nullable Boolean shouldRecordScreenshot) {
                if (shouldRecordScreenshot != null && shouldRecordScreenshot.booleanValue()) {
                    NavigationViewSubscriber.this.navigationPresenter.onShouldRecordScreenshot();
                }
            }
        });
    }
}

