/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewModel;
import com.mapbox.services.android.navigation.ui.v5.ViewRouteListener;

class NavigationViewRouteEngineListener
implements ViewRouteListener {
    private final NavigationViewModel navigationViewModel;

    NavigationViewRouteEngineListener(NavigationViewModel navigationViewModel) {
        this.navigationViewModel = navigationViewModel;
    }

    @Override
    public void onRouteUpdate(DirectionsRoute directionsRoute) {
        this.navigationViewModel.updateRoute(directionsRoute);
    }

    @Override
    public void onRouteRequestError(String errorMessage) {
        if (this.navigationViewModel.isOffRoute()) {
            this.navigationViewModel.sendEventFailedReroute(errorMessage);
        }
    }

    @Override
    public void onDestinationSet(Point destination) {
        this.navigationViewModel.retrieveDestination().setValue((Object)destination);
    }
}

