/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.services.android.navigation.ui.v5.MapOfflineOptions;
import com.mapbox.services.android.navigation.ui.v5.NavigationLauncher;
import com.mapbox.services.android.navigation.ui.v5.NavigationView;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewOptions;
import com.mapbox.services.android.navigation.ui.v5.OnNavigationReadyCallback;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.listeners.NavigationListener;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigationOptions;

public class MapboxNavigationActivity
extends AppCompatActivity
implements OnNavigationReadyCallback,
NavigationListener {
    private NavigationView navigationView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setTheme(R.style.Theme_AppCompat_NoActionBar);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_navigation);
        this.navigationView = (NavigationView)this.findViewById(R.id.navigationView);
        this.navigationView.onCreate(savedInstanceState);
        this.initialize();
    }

    public void onStart() {
        super.onStart();
        this.navigationView.onStart();
    }

    public void onResume() {
        super.onResume();
        this.navigationView.onResume();
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.navigationView.onLowMemory();
    }

    public void onBackPressed() {
        if (!this.navigationView.onBackPressed()) {
            super.onBackPressed();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        this.navigationView.onSaveInstanceState(outState);
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.navigationView.onRestoreInstanceState(savedInstanceState);
    }

    public void onPause() {
        super.onPause();
        this.navigationView.onPause();
    }

    public void onStop() {
        super.onStop();
        this.navigationView.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.navigationView.onDestroy();
    }

    @Override
    public void onNavigationReady(boolean isRunning) {
        NavigationViewOptions.Builder options = NavigationViewOptions.builder();
        options.navigationListener(this);
        this.extractRoute(options);
        this.extractConfiguration(options);
        options.navigationOptions(MapboxNavigationOptions.builder().build());
        this.navigationView.startNavigation(options.build());
    }

    @Override
    public void onCancelNavigation() {
        this.finishNavigation();
    }

    @Override
    public void onNavigationFinished() {
        this.finishNavigation();
    }

    @Override
    public void onNavigationRunning() {
    }

    private void initialize() {
        Parcelable position = this.getIntent().getParcelableExtra("navigation_view_initial_map_position");
        if (position != null) {
            this.navigationView.initialize(this, (CameraPosition)position);
        } else {
            this.navigationView.initialize(this);
        }
    }

    private void extractRoute(NavigationViewOptions.Builder options) {
        DirectionsRoute route = NavigationLauncher.extractRoute((Context)this);
        options.directionsRoute(route);
    }

    private void extractConfiguration(NavigationViewOptions.Builder options) {
        String offlineVersion;
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        options.shouldSimulateRoute(preferences.getBoolean("navigation_view_simulate_route", false));
        String offlinePath = preferences.getString("offline_path_key", "");
        if (!offlinePath.isEmpty()) {
            options.offlineRoutingTilesPath(offlinePath);
        }
        if (!(offlineVersion = preferences.getString("offline_version_key", "")).isEmpty()) {
            options.offlineRoutingTilesVersion(offlineVersion);
        }
        String offlineMapDatabasePath = preferences.getString("offline_map_database_path_key", "");
        String offlineMapStyleUrl = preferences.getString("offline_map_style_url_key", "");
        if (!offlineMapDatabasePath.isEmpty() && !offlineMapStyleUrl.isEmpty()) {
            MapOfflineOptions mapOfflineOptions = new MapOfflineOptions(offlineMapDatabasePath, offlineMapStyleUrl);
            options.offlineMapOptions(mapOfflineOptions);
        }
    }

    private void finishNavigation() {
        NavigationLauncher.cleanUpPreferences((Context)this);
        this.finish();
    }
}

