/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import com.github.tomakehurst.wiremock.common.BrowserProxySettings;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.http.ssl.CertificateAuthority;
import com.github.tomakehurst.wiremock.http.ssl.CertificateGenerationUnsupportedException;
import com.github.tomakehurst.wiremock.http.ssl.X509KeyStore;
import com.github.tomakehurst.wiremock.jetty11.CertificateGeneratingSslContextFactory;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import wiremock.org.eclipse.jetty.http2.HTTP2Cipher;
import wiremock.org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslContexts {
    public static SslContextFactory.Server buildHttp2SslContextFactory(HttpsSettings httpsSettings) {
        SslContextFactory.Server sslContextFactory = SslContexts.defaultSslContextFactory(httpsSettings.keyStore());
        sslContextFactory.setKeyManagerPassword(httpsSettings.keyManagerPassword());
        SslContexts.setupClientAuth(sslContextFactory, httpsSettings);
        sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        return sslContextFactory;
    }

    public static SslContextFactory.Server buildHttp1_1SslContextFactory(HttpsSettings httpsSettings) {
        SslContextFactory.Server sslContextFactory = SslContexts.defaultSslContextFactory(httpsSettings.keyStore());
        sslContextFactory.setKeyManagerPassword(httpsSettings.keyManagerPassword());
        SslContexts.setupClientAuth(sslContextFactory, httpsSettings);
        return sslContextFactory;
    }

    public static SslContextFactory.Server buildManInTheMiddleSslContextFactory(HttpsSettings httpsSettings, BrowserProxySettings browserProxySettings, Notifier notifier) {
        KeyStoreSettings browserProxyCaKeyStore = browserProxySettings.caKeyStore();
        SslContextFactory.Server sslContextFactory = SslContexts.buildSslContextFactory(notifier, browserProxyCaKeyStore, httpsSettings.keyStore());
        SslContexts.setupClientAuth(sslContextFactory, httpsSettings);
        return sslContextFactory;
    }

    private static void setupClientAuth(SslContextFactory.Server sslContextFactory, HttpsSettings httpsSettings) {
        if (httpsSettings.hasTrustStore()) {
            sslContextFactory.setTrustStorePath(httpsSettings.trustStorePath());
            sslContextFactory.setTrustStorePassword(httpsSettings.trustStorePassword());
        }
        sslContextFactory.setNeedClientAuth(httpsSettings.needClientAuth());
    }

    private static SslContextFactory.Server buildSslContextFactory(Notifier notifier, KeyStoreSettings browserProxyCaKeyStore, KeyStoreSettings defaultHttpsKeyStore) {
        if (browserProxyCaKeyStore.exists()) {
            X509KeyStore existingKeyStore = SslContexts.toX509KeyStore(browserProxyCaKeyStore);
            return SslContexts.certificateGeneratingSslContextFactory(notifier, browserProxyCaKeyStore, existingKeyStore);
        }
        try {
            X509KeyStore newKeyStore = SslContexts.buildKeyStore(browserProxyCaKeyStore);
            return SslContexts.certificateGeneratingSslContextFactory(notifier, browserProxyCaKeyStore, newKeyStore);
        }
        catch (Exception e) {
            notifier.error("Unable to generate a certificate authority", e);
            return SslContexts.defaultSslContextFactory(defaultHttpsKeyStore);
        }
    }

    private static SslContextFactory.Server defaultSslContextFactory(KeyStoreSettings defaultHttpsKeyStore) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        SslContexts.setupKeyStore(sslContextFactory, defaultHttpsKeyStore);
        return sslContextFactory;
    }

    private static SslContextFactory.Server certificateGeneratingSslContextFactory(Notifier notifier, KeyStoreSettings browserProxyCaKeyStore, X509KeyStore newKeyStore) {
        CertificateGeneratingSslContextFactory sslContextFactory = new CertificateGeneratingSslContextFactory(newKeyStore, notifier);
        SslContexts.setupKeyStore(sslContextFactory, browserProxyCaKeyStore);
        sslContextFactory.setKeyStorePassword(browserProxyCaKeyStore.password());
        return sslContextFactory;
    }

    private static void setupKeyStore(SslContextFactory.Server sslContextFactory, KeyStoreSettings keyStoreSettings) {
        sslContextFactory.setKeyStore(keyStoreSettings.loadStore());
        sslContextFactory.setKeyStorePassword(keyStoreSettings.password());
        sslContextFactory.setKeyStoreType(keyStoreSettings.type());
    }

    private static X509KeyStore toX509KeyStore(KeyStoreSettings browserProxyCaKeyStore) {
        try {
            return new X509KeyStore(browserProxyCaKeyStore.loadStore(), browserProxyCaKeyStore.password().toCharArray());
        }
        catch (KeyStoreException e) {
            return (X509KeyStore)Exceptions.throwUnchecked(e, null);
        }
    }

    private static X509KeyStore buildKeyStore(KeyStoreSettings browserProxyCaKeyStore) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, CertificateGenerationUnsupportedException {
        CertificateAuthority certificateAuthority = CertificateAuthority.generateCertificateAuthority();
        KeyStore keyStore = KeyStore.getInstance(browserProxyCaKeyStore.type());
        char[] password = browserProxyCaKeyStore.password().toCharArray();
        keyStore.load(null, password);
        keyStore.setKeyEntry("wiremock-ca", certificateAuthority.key(), password, certificateAuthority.certificateChain());
        browserProxyCaKeyStore.getSource().save(keyStore);
        return new X509KeyStore(keyStore, password);
    }
}

