/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.Lazy;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import java.util.function.Supplier;

public class LazyTemplateEngine
extends TemplateEngine {
    private final Lazy<TemplateEngine> templateEngineLazy;

    public LazyTemplateEngine(Supplier<TemplateEngine> templateEngineSupplier) {
        this.templateEngineLazy = Lazy.lazy(templateEngineSupplier);
    }

    @Override
    public HandlebarsOptimizedTemplate getTemplate(Object key, String content) {
        return this.templateEngineLazy.get().getTemplate(key, content);
    }

    @Override
    public HandlebarsOptimizedTemplate getUncachedTemplate(String content) {
        return this.templateEngineLazy.get().getUncachedTemplate(content);
    }

    @Override
    public long getCacheSize() {
        return this.templateEngineLazy.get().getCacheSize();
    }

    @Override
    public void invalidateCache() {
        this.templateEngineLazy.get().invalidateCache();
    }

    @Override
    public Long getMaxCacheEntries() {
        return this.templateEngineLazy.get().getMaxCacheEntries();
    }
}

