/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;

public class MultiValue {
    protected final String key;
    protected final List<String> values;

    public MultiValue(String key, List<String> values) {
        this.key = key;
        this.values = values;
    }

    public boolean isPresent() {
        return !this.values.isEmpty();
    }

    public String key() {
        return this.key;
    }

    public String firstValue() {
        this.checkPresent();
        return this.values.get(0);
    }

    public List<String> values() {
        this.checkPresent();
        return this.values;
    }

    private void checkPresent() {
        Preconditions.checkState((boolean)this.isPresent(), (Object)("No value for " + this.key));
    }

    public boolean isSingleValued() {
        return this.values.size() == 1;
    }

    public boolean containsValue(String expectedValue) {
        return this.values.contains(expectedValue);
    }

    public boolean hasValueMatching(StringValuePattern valuePattern) {
        return valuePattern.nullSafeIsAbsent() && !this.isPresent() || this.anyValueMatches(valuePattern);
    }

    private boolean anyValueMatches(StringValuePattern valuePattern) {
        return this.values.stream().anyMatch(headerValue -> valuePattern.match(headerValue).isExactMatch());
    }

    public String toString() {
        return this.values.stream().map(value -> this.key + ": " + value).collect(Collectors.joining("\n"));
    }
}

