/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import com.github.tomakehurst.wiremock.verification.diff.DiffLine;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PlainTextDiffRenderer {
    private final String SEPARATOR = System.lineSeparator();
    private final int consoleWidth;
    private final Map<String, RequestMatcherExtension> customMatcherExtensions;

    public PlainTextDiffRenderer(Map<String, RequestMatcherExtension> customMatcherExtensions) {
        this(customMatcherExtensions, 119);
    }

    public PlainTextDiffRenderer(Map<String, RequestMatcherExtension> customMatcherExtensions, int consoleWidth) {
        this.customMatcherExtensions = customMatcherExtensions;
        this.consoleWidth = consoleWidth;
    }

    public String render(Diff diff) {
        StringBuilder sb = new StringBuilder();
        this.header(sb);
        if (diff.getStubMappingName() != null) {
            this.writeLine(sb, diff.getStubMappingName(), "", null);
            this.writeBlankLine(sb);
        }
        for (DiffLine<?> line : diff.getLines(this.customMatcherExtensions)) {
            boolean isBodyLine = line.getRequestAttribute().equals("Body");
            if (isBodyLine && !line.isForNonMatch()) continue;
            this.writeLine(sb, line.getPrintedPatternValue(), line.getActual().toString(), line.getMessage());
        }
        this.writeBlankLine(sb);
        this.footer(sb);
        return sb.toString();
    }

    private void header(StringBuilder sb) {
        String titleLine = "Request was not matched";
        int middle = this.getMiddle();
        int titleLinePaddingLeft = middle - titleLine.length() / 2;
        sb.append(this.SEPARATOR).append(StringUtils.repeat((char)' ', (int)titleLinePaddingLeft)).append(titleLine).append(this.SEPARATOR).append(StringUtils.repeat((char)' ', (int)titleLinePaddingLeft)).append(StringUtils.repeat((char)'=', (int)titleLine.length())).append(this.SEPARATOR).append(this.SEPARATOR).append(StringUtils.repeat((char)'-', (int)this.consoleWidth)).append(this.SEPARATOR).append('|').append(StringUtils.rightPad((String)" Closest stub", (int)middle)).append('|').append(StringUtils.rightPad((String)" Request", (int)middle, (char)' ')).append('|').append(this.SEPARATOR).append(StringUtils.repeat((char)'-', (int)this.consoleWidth)).append(this.SEPARATOR);
        this.writeBlankLine(sb);
    }

    private void footer(StringBuilder sb) {
        sb.append(StringUtils.repeat((char)'-', (int)this.consoleWidth)).append(this.SEPARATOR);
    }

    private void writeLine(StringBuilder sb, String left, String right, String message) {
        String[] leftLines = this.wrap(Strings.normaliseLineBreaks(left)).split(this.SEPARATOR);
        String[] rightLines = this.wrap(Strings.normaliseLineBreaks(right)).split(this.SEPARATOR);
        int maxLines = Math.max(leftLines.length, rightLines.length);
        this.writeSingleLine(sb, PlainTextDiffRenderer.firstOrEmpty(leftLines), PlainTextDiffRenderer.firstOrEmpty(rightLines), message);
        if (maxLines > 1) {
            for (int i = 1; i < maxLines; ++i) {
                String leftPart = leftLines.length > i ? leftLines[i] : "";
                String rightPart = rightLines.length > i ? rightLines[i] : "";
                this.writeSingleLine(sb, leftPart, rightPart, null);
            }
        }
    }

    private static String firstOrEmpty(String[] lines) {
        return lines.length > 0 ? lines[0] : "";
    }

    private void writeBlankLine(StringBuilder sb) {
        this.writeSingleLine(sb, "", null, null);
    }

    private void writeSingleLine(StringBuilder sb, String left, String right, String message) {
        sb.append("").append(StringUtils.rightPad((String)left, (int)(this.getMiddle() + 1), (String)" ")).append("|");
        if (StringUtils.isNotEmpty((CharSequence)right)) {
            sb.append(" ");
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                sb.append(StringUtils.rightPad((String)right, (int)(this.getMiddle() - 6), (String)" ")).append("<<<<< ").append(message);
            } else {
                sb.append(right);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)message)) {
            sb.append(StringUtils.rightPad((String)right, (int)(this.getMiddle() - 5), (String)" ")).append("<<<<< ").append(message);
        }
        sb.append(this.SEPARATOR);
    }

    private String wrap(String s) {
        String safeString = s == null ? "" : s;
        return Strings.wrapIfLongestLineExceedsLimit(safeString, this.getColumnWidth());
    }

    private int getColumnWidth() {
        return this.consoleWidth / 2 - 2;
    }

    private int getMiddle() {
        return this.consoleWidth / 2 - 1;
    }
}

