/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Json;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Metadata
extends LinkedHashMap<String, Object> {
    public Metadata() {
    }

    public Metadata(Map<? extends String, ?> data) {
        super(data);
    }

    public Integer getInt(String key) {
        return this.checkPresenceValidityAndCast(key, Integer.class);
    }

    public Integer getInt(String key, Integer defaultValue) {
        return this.returnIfValidOrDefaultIfNot(key, Integer.class, defaultValue);
    }

    public Boolean getBoolean(String key) {
        return this.checkPresenceValidityAndCast(key, Boolean.class);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.returnIfValidOrDefaultIfNot(key, Boolean.class, defaultValue);
    }

    public String getString(String key) {
        return this.checkPresenceValidityAndCast(key, String.class);
    }

    public String getString(String key, String defaultValue) {
        return this.returnIfValidOrDefaultIfNot(key, String.class, defaultValue);
    }

    public List<?> getList(String key) {
        return this.checkPresenceValidityAndCast(key, List.class);
    }

    public Metadata getMetadata(String key) {
        this.checkKeyPresent(key);
        Preconditions.checkArgument((boolean)Map.class.isAssignableFrom(this.get(key).getClass()), (Object)(key + " is not a map"));
        return new Metadata((Map)this.get(key));
    }

    public Metadata getMetadata(String key, Metadata defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        Preconditions.checkArgument((boolean)Map.class.isAssignableFrom(this.get(key).getClass()), (Object)(key + " is not a map"));
        return new Metadata((Map)this.get(key));
    }

    private <T> T checkPresenceValidityAndCast(String key, Class<T> type) {
        this.checkKeyPresent(key);
        Preconditions.checkArgument((boolean)type.isAssignableFrom(this.get(key).getClass()), (Object)(key + " is not of type " + type.getSimpleName()));
        return (T)this.get(key);
    }

    private <T> T returnIfValidOrDefaultIfNot(String key, Class<T> type, T defaultValue) {
        if (!this.containsKey(key) || !type.isAssignableFrom(this.get(key).getClass())) {
            return defaultValue;
        }
        return (T)this.get(key);
    }

    private void checkKeyPresent(String key) {
        Preconditions.checkArgument((boolean)this.containsKey(key), (Object)(key + "' not present"));
    }

    public static <T> Metadata from(T myData) {
        return new Metadata((Map<? extends String, ?>)Json.objectToMap(myData));
    }

    public static Builder metadata() {
        return new Builder();
    }

    public <T> T as(Class<T> myDataClass) {
        return Json.mapToObject(this, myDataClass);
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Object> mapBuilder = ImmutableMap.builder();

        public Builder attr(String key, Object value) {
            this.mapBuilder.put((Object)key, value);
            return this;
        }

        public Builder list(String key, Object ... values) {
            this.mapBuilder.put((Object)key, (Object)ImmutableList.copyOf((Object[])values));
            return this;
        }

        public Builder attr(String key, Builder metadataBuilder) {
            this.mapBuilder.put((Object)key, (Object)metadataBuilder.build());
            return this;
        }

        public Metadata build() {
            return new Metadata((Map<? extends String, ?>)this.mapBuilder.build());
        }
    }
}

