/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class DateTimeOffset {
    public static final DateTimeOffset NONE = new DateTimeOffset(0, DateTimeUnit.SECONDS);
    private final DateTimeUnit amountUnit;
    private final int amount;

    public static DateTimeOffset fromString(String offset) {
        DateTimeUnit amountUnit;
        int amount;
        if (offset.equalsIgnoreCase("now")) {
            return NONE;
        }
        String[] parts = offset.split(" ");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("Offset can be of the short form <amount> <unit> e.g. 8 seconds or long form now +/-<amount> <unit> e.g. now +5 years");
        }
        if (parts.length == 2) {
            amount = Integer.parseInt(parts[0]);
            amountUnit = DateTimeUnit.valueOf(parts[1].toUpperCase());
        } else {
            amount = Integer.parseInt(parts[1]);
            amountUnit = DateTimeUnit.valueOf(parts[2].toUpperCase());
        }
        return new DateTimeOffset(amount, amountUnit);
    }

    public DateTimeOffset(int amount, DateTimeUnit amountUnit) {
        this.amountUnit = amountUnit;
        this.amount = amount;
    }

    public DateTimeUnit getAmountUnit() {
        return this.amountUnit;
    }

    public int getAmount() {
        return this.amount;
    }

    public Date shift(Date date) {
        if (this == NONE) {
            return date;
        }
        ZonedDateTime input = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.of("Z"));
        ZonedDateTime output = this.shift(input);
        return Date.from(output.toInstant());
    }

    public ZonedDateTime shift(ZonedDateTime dateTime) {
        if (this == NONE) {
            return dateTime;
        }
        return dateTime.plus(this.amount, this.amountUnit.toTemporalUnit());
    }

    public String toString() {
        return this.amount + " " + this.amountUnit.name().toLowerCase();
    }
}

