/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.ServletContextFileSource;
import com.github.tomakehurst.wiremock.common.Slf4jNotifier;
import com.github.tomakehurst.wiremock.core.WireMockApp;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.servlet.NotImplementedContainer;
import com.github.tomakehurst.wiremock.servlet.NotImplementedMappingsSaver;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class WireMockWebContextListener
implements ServletContextListener {
    private static final String FILES_ROOT = "__files";
    private static final String APP_CONTEXT_KEY = "WireMockApp";
    private static final String FILE_SOURCE_ROOT_KEY = "WireMockFileSourceRoot";

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        String fileSourceRoot = context.getInitParameter(FILE_SOURCE_ROOT_KEY);
        ServletContextFileSource fileSource = new ServletContextFileSource(context, fileSourceRoot);
        Optional<Integer> maxRequestJournalEntries = this.readMaxRequestJournalEntries(context);
        boolean verboseLoggingEnabled = Boolean.parseBoolean((String)MoreObjects.firstNonNull((Object)context.getInitParameter("verboseLoggingEnabled"), (Object)"true"));
        JsonFileMappingsSource defaultMappingsLoader = new JsonFileMappingsSource(fileSource.child("mappings"));
        NotImplementedMappingsSaver mappingsSaver = new NotImplementedMappingsSaver();
        WireMockApp wireMockApp = new WireMockApp(false, defaultMappingsLoader, mappingsSaver, false, maxRequestJournalEntries, Collections.emptyMap(), Collections.emptyMap(), fileSource, new NotImplementedContainer());
        AdminRequestHandler adminRequestHandler = new AdminRequestHandler(wireMockApp, new BasicResponseRenderer());
        StubRequestHandler stubRequestHandler = new StubRequestHandler(wireMockApp, new StubResponseRenderer(fileSource.child(FILES_ROOT), wireMockApp.getGlobalSettingsHolder(), new ProxyResponseRenderer(), Collections.emptyList()));
        context.setAttribute(APP_CONTEXT_KEY, (Object)wireMockApp);
        context.setAttribute(StubRequestHandler.class.getName(), (Object)stubRequestHandler);
        context.setAttribute(AdminRequestHandler.class.getName(), (Object)adminRequestHandler);
        context.setAttribute("Notifier", (Object)new Slf4jNotifier(verboseLoggingEnabled));
    }

    private Optional<Integer> readMaxRequestJournalEntries(ServletContext context) {
        String str = context.getInitParameter("maxRequestJournalEntries");
        if (str == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Integer.parseInt(str));
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

