/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class InMemoryRequestJournal
implements RequestListener,
RequestJournal {
    private final Queue<LoggedRequest> requests = new ConcurrentLinkedQueue<LoggedRequest>();
    private final Optional<Integer> maxEntries;

    public InMemoryRequestJournal(Optional<Integer> maxEntries) {
        if (maxEntries.isPresent() && (Integer)maxEntries.get() < 0) {
            throw new IllegalArgumentException("Maximum number of entries of journal must be greater than zero");
        }
        this.maxEntries = maxEntries;
    }

    @Override
    public int countRequestsMatching(RequestPattern requestPattern) {
        return Iterables.size((Iterable)Iterables.filter(this.requests, this.matchedBy(requestPattern)));
    }

    @Override
    public List<LoggedRequest> getRequestsMatching(RequestPattern requestPattern) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.requests, this.matchedBy(requestPattern)));
    }

    private Predicate<Request> matchedBy(final RequestPattern requestPattern) {
        return new Predicate<Request>(){

            public boolean apply(Request input) {
                return requestPattern.isMatchedBy(input);
            }
        };
    }

    @Override
    public void requestReceived(Request request, Response response) {
        this.requests.add(LoggedRequest.createFrom(request));
        this.removeOldEntries();
    }

    @Override
    public void requestReceived(Request request) {
        this.requestReceived(request, null);
    }

    @Override
    public void reset() {
        this.requests.clear();
    }

    private void removeOldEntries() {
        if (this.maxEntries.isPresent()) {
            while (this.requests.size() > (Integer)this.maxEntries.get()) {
                this.requests.poll();
            }
        }
    }
}

