/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeadersJsonDeserializer;
import com.github.tomakehurst.wiremock.http.HttpHeadersJsonSerializer;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

@JsonSerialize(using=HttpHeadersJsonSerializer.class)
@JsonDeserialize(using=HttpHeadersJsonDeserializer.class)
public class HttpHeaders {
    private final Multimap<CaseInsensitiveKey, String> headers;

    public HttpHeaders() {
        this.headers = ImmutableMultimap.of();
    }

    public HttpHeaders(HttpHeader ... headers) {
        this((Iterable<HttpHeader>)ImmutableList.copyOf((Object[])headers));
    }

    public HttpHeaders(Iterable<HttpHeader> headers) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (HttpHeader header : headers) {
            builder.putAll((Object)this.caseInsensitive(header.key()), header.values());
        }
        this.headers = builder.build();
    }

    public HttpHeaders(HttpHeaders headers) {
        this(headers.all());
    }

    public static HttpHeaders noHeaders() {
        return new HttpHeaders();
    }

    public HttpHeader getHeader(String key) {
        if (!this.headers.containsKey((Object)this.caseInsensitive(key))) {
            return HttpHeader.absent(key);
        }
        Collection values = this.headers.get((Object)this.caseInsensitive(key));
        return new HttpHeader(key, (Collection<String>)values);
    }

    public ContentTypeHeader getContentTypeHeader() {
        HttpHeader header = this.getHeader("Content-Type");
        if (header.isPresent()) {
            return new ContentTypeHeader(this.getHeader("Content-Type").firstValue());
        }
        return ContentTypeHeader.absent();
    }

    public Collection<HttpHeader> all() {
        ArrayList httpHeaderList = Lists.newArrayList();
        for (CaseInsensitiveKey key : this.headers.keySet()) {
            httpHeaderList.add(new HttpHeader(key.value(), (Collection<String>)this.headers.get((Object)key)));
        }
        return httpHeaderList;
    }

    public Set<String> keys() {
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)this.headers.keySet(), (Function)Functions.toStringFunction()));
    }

    public static HttpHeaders copyOf(HttpHeaders source) {
        return new HttpHeaders(source);
    }

    public int size() {
        return this.headers.asMap().size();
    }

    public HttpHeaders plus(HttpHeader ... additionalHeaders) {
        return new HttpHeaders((Iterable<HttpHeader>)ImmutableList.builder().addAll(this.all()).addAll(Arrays.asList(additionalHeaders)).build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeaders that = (HttpHeaders)o;
        return !(this.headers != null ? !this.headers.equals(that.headers) : that.headers != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }

    public String toString() {
        String outString = "HttpHeaders: ";
        if (this.headers.isEmpty()) {
            outString = outString + "[]";
            return outString;
        }
        for (CaseInsensitiveKey key : this.headers.keySet()) {
            outString = outString + key.toString() + ": " + this.headers.get((Object)key).toString() + "\n";
        }
        return outString;
    }

    private CaseInsensitiveKey caseInsensitive(String key) {
        return new CaseInsensitiveKey(key);
    }
}

