/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.RequestDelayControl;
import com.github.tomakehurst.wiremock.client.RequestDelaySpec;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.mapping.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.mapping.Json;
import com.github.tomakehurst.wiremock.mapping.JsonMappingCreator;
import com.github.tomakehurst.wiremock.mapping.Mappings;
import com.github.tomakehurst.wiremock.mapping.Request;
import com.github.tomakehurst.wiremock.mapping.RequestPattern;
import com.github.tomakehurst.wiremock.mapping.ResponseDefinition;
import com.github.tomakehurst.wiremock.servlet.ResponseRenderer;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.List;

public class AdminRequestHandler
extends AbstractRequestHandler {
    private final Mappings mappings;
    private final JsonMappingCreator jsonMappingCreator;
    private final RequestJournal requestJournal;
    private final GlobalSettingsHolder globalSettingsHolder;
    private final RequestDelayControl requestDelayControl;

    public AdminRequestHandler(Mappings mappings, RequestJournal requestJournal, GlobalSettingsHolder globalSettingsHolder, ResponseRenderer responseRenderer, RequestDelayControl requestDelayControl) {
        super(responseRenderer);
        this.mappings = mappings;
        this.requestJournal = requestJournal;
        this.globalSettingsHolder = globalSettingsHolder;
        this.requestDelayControl = requestDelayControl;
        this.jsonMappingCreator = new JsonMappingCreator(mappings);
    }

    @Override
    public ResponseDefinition handleRequest(Request request) {
        LocalNotifier.notifier().info("Received request to " + request.getUrl() + " with body " + request.getBodyAsString());
        if (this.isNewMappingRequest(request)) {
            this.jsonMappingCreator.addMappingFrom(request.getBodyAsString());
            return ResponseDefinition.created();
        }
        if (this.isResetRequest(request)) {
            this.mappings.reset();
            this.requestJournal.reset();
            this.requestDelayControl.clearDelay();
            return ResponseDefinition.ok();
        }
        if (this.isResetScenariosRequest(request)) {
            this.mappings.resetScenarios();
            return ResponseDefinition.ok();
        }
        if (this.isRequestCountRequest(request)) {
            return this.getRequestCount(request);
        }
        if (this.isFindRequestsRequest(request)) {
            return this.findRequests(request);
        }
        if (this.isGlobalSettingsUpdateRequest(request)) {
            GlobalSettings newSettings = Json.read(request.getBodyAsString(), GlobalSettings.class);
            this.globalSettingsHolder.replaceWith(newSettings);
            return ResponseDefinition.ok();
        }
        if (this.isSocketDelayRequest(request)) {
            RequestDelaySpec delaySpec = Json.read(request.getBodyAsString(), RequestDelaySpec.class);
            this.requestDelayControl.setDelay(delaySpec.milliseconds());
            return ResponseDefinition.ok();
        }
        return ResponseDefinition.notFound();
    }

    private boolean isGlobalSettingsUpdateRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/settings");
    }

    private ResponseDefinition getRequestCount(Request request) {
        RequestPattern requestPattern = Json.buildRequestPatternFrom(request.getBodyAsString());
        int matchingRequestCount = this.requestJournal.countRequestsMatching(requestPattern);
        ResponseDefinition response = new ResponseDefinition(200, Json.write(new VerificationResult(matchingRequestCount)));
        response.setHeaders(new HttpHeaders(HttpHeader.httpHeader("Content-Type", "application/json")));
        return response;
    }

    private ResponseDefinition findRequests(Request request) {
        RequestPattern requestPattern = Json.buildRequestPatternFrom(request.getBodyAsString());
        List<LoggedRequest> requests = this.requestJournal.getRequestsMatching(requestPattern);
        ResponseDefinition response = new ResponseDefinition(200, Json.write(new FindRequestsResult(requests)));
        response.setHeaders(new HttpHeaders(HttpHeader.httpHeader("Content-Type", "application/json")));
        return response;
    }

    private boolean isResetRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/reset");
    }

    private boolean isResetScenariosRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/scenarios/reset");
    }

    private boolean isNewMappingRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/mappings/new");
    }

    private boolean isRequestCountRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/requests/count");
    }

    private boolean isFindRequestsRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/requests/find");
    }

    private boolean isSocketDelayRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/socket-delay");
    }

    private static String withoutAdminRoot(String url) {
        return url.replace("/__admin", "");
    }
}

