/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.mapping.Json;
import com.github.tomakehurst.wiremock.mapping.Request;
import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ResponseDefinition {
    private int status;
    private byte[] body;
    private boolean isBinaryBody = false;
    private String bodyFileName;
    private HttpHeaders headers;
    private Integer fixedDelayMilliseconds;
    private String proxyBaseUrl;
    private String browserProxyUrl;
    private Fault fault;
    private boolean wasConfigured = true;
    private Request originalRequest;

    public static ResponseDefinition copyOf(ResponseDefinition original) {
        ResponseDefinition newResponseDef = new ResponseDefinition();
        newResponseDef.status = original.status;
        newResponseDef.body = original.body;
        newResponseDef.isBinaryBody = original.isBinaryBody;
        newResponseDef.bodyFileName = original.bodyFileName;
        newResponseDef.headers = original.headers;
        newResponseDef.fixedDelayMilliseconds = original.fixedDelayMilliseconds;
        newResponseDef.proxyBaseUrl = original.proxyBaseUrl;
        newResponseDef.fault = original.fault;
        newResponseDef.wasConfigured = original.wasConfigured;
        return newResponseDef;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public ResponseDefinition(int statusCode, String bodyContent) {
        this.status = statusCode;
        this.body = bodyContent == null ? null : bodyContent.getBytes(Charset.forName(Charsets.UTF_8.name()));
    }

    public ResponseDefinition(int statusCode, byte[] bodyContent) {
        this.status = statusCode;
        this.body = bodyContent;
        this.isBinaryBody = true;
    }

    public ResponseDefinition() {
        this.status = 200;
    }

    public static ResponseDefinition notFound() {
        return new ResponseDefinition(404, (byte[])null);
    }

    public static ResponseDefinition ok() {
        return new ResponseDefinition(200, (byte[])null);
    }

    public static ResponseDefinition created() {
        return new ResponseDefinition(201, (byte[])null);
    }

    public static ResponseDefinition notConfigured() {
        ResponseDefinition response = new ResponseDefinition(404, (byte[])null);
        response.wasConfigured = false;
        return response;
    }

    public static ResponseDefinition browserProxy(Request originalRequest) {
        ResponseDefinition response = new ResponseDefinition();
        response.browserProxyUrl = originalRequest.getAbsoluteUrl();
        return response;
    }

    public int getStatus() {
        return this.status;
    }

    public String getBody() {
        return !this.isBinaryBody && this.body != null ? new String(this.body, Charset.forName(Charsets.UTF_8.name())) : null;
    }

    @JsonIgnore
    public byte[] getByteBody() {
        return this.body;
    }

    public String getBase64Body() {
        if (this.isBinaryBody && this.body != null) {
            return DatatypeConverter.printBase64Binary((byte[])this.body);
        }
        return null;
    }

    public void setBase64Body(String base64Body) {
        this.isBinaryBody = true;
        this.body = DatatypeConverter.parseBase64Binary((String)base64Body);
    }

    public void setBody(String body) {
        this.body = body != null ? body.getBytes(Charset.forName(Charsets.UTF_8.name())) : null;
        this.isBinaryBody = false;
    }

    @JsonIgnore
    public void setBody(byte[] body) {
        this.body = body;
        this.isBinaryBody = true;
    }

    public void setStatus(int status) {
        this.status = status == 0 ? 200 : status;
    }

    public void setFixedDelayMilliseconds(Integer fixedDelayMilliseconds) {
        this.fixedDelayMilliseconds = fixedDelayMilliseconds;
    }

    public String getBodyFileName() {
        return this.bodyFileName;
    }

    public void setBodyFileName(String bodyFileName) {
        this.bodyFileName = bodyFileName;
    }

    public boolean wasConfigured() {
        return this.wasConfigured;
    }

    public Integer getFixedDelayMilliseconds() {
        return this.fixedDelayMilliseconds;
    }

    @JsonIgnore
    public String getProxyUrl() {
        if (this.browserProxyUrl != null) {
            return this.browserProxyUrl;
        }
        return this.proxyBaseUrl + this.originalRequest.getUrl();
    }

    public String getProxyBaseUrl() {
        return this.proxyBaseUrl;
    }

    public void setProxyBaseUrl(String proxyBaseUrl) {
        this.proxyBaseUrl = proxyBaseUrl;
    }

    @JsonIgnore
    public boolean specifiesBodyFile() {
        return this.bodyFileName != null;
    }

    @JsonIgnore
    public boolean specifiesBodyContent() {
        return this.body != null;
    }

    @JsonIgnore
    public boolean specifiesBinaryBodyContent() {
        return this.body != null && this.isBinaryBody;
    }

    @JsonIgnore
    public boolean isProxyResponse() {
        return this.browserProxyUrl != null || this.proxyBaseUrl != null;
    }

    public Request getOriginalRequest() {
        return this.originalRequest;
    }

    public void setOriginalRequest(Request originalRequest) {
        this.originalRequest = originalRequest;
    }

    public Fault getFault() {
        return this.fault;
    }

    public void setFault(Fault fault) {
        this.fault = fault;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.bodyFileName == null ? 0 : this.bodyFileName.hashCode());
        result = 31 * result + (this.fault == null ? 0 : this.fault.hashCode());
        result = 31 * result + (this.fixedDelayMilliseconds == null ? 0 : this.fixedDelayMilliseconds.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.originalRequest == null ? 0 : this.originalRequest.hashCode());
        result = 31 * result + (this.proxyBaseUrl == null ? 0 : this.proxyBaseUrl.hashCode());
        result = 31 * result + this.status;
        result = 31 * result + (this.wasConfigured ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseDefinition other = (ResponseDefinition)obj;
        if (this.body == null ? other.body != null : !ResponseDefinition.byteBodyEquals(this.body, other.body)) {
            return false;
        }
        if (this.bodyFileName == null ? other.bodyFileName != null : !this.bodyFileName.equals(other.bodyFileName)) {
            return false;
        }
        if (this.fault != other.fault) {
            return false;
        }
        if (this.fixedDelayMilliseconds == null ? other.fixedDelayMilliseconds != null : !this.fixedDelayMilliseconds.equals(other.fixedDelayMilliseconds)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.proxyBaseUrl == null ? other.proxyBaseUrl != null : !this.proxyBaseUrl.equals(other.proxyBaseUrl)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.wasConfigured == other.wasConfigured;
    }

    private static boolean byteBodyEquals(byte[] expecteds, byte[] actuals) {
        if (expecteds == actuals) {
            return true;
        }
        if (expecteds == null) {
            return false;
        }
        if (actuals == null) {
            return false;
        }
        int actualsLength = actuals.length;
        int expectedsLength = expecteds.length;
        if (actualsLength != expectedsLength) {
            return false;
        }
        for (int i = 0; i < expectedsLength; ++i) {
            byte expected = expecteds[i];
            byte actual = actuals[i];
            if (expected == actual) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Json.write(this);
    }
}

