/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.mapping.Request;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class LoggedRequest
implements Request {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private String url;
    private String absoluteUrl;
    private RequestMethod method;
    private HttpHeaders headers = new HttpHeaders();
    private String body;
    private boolean isBrowserProxyRequest;
    private Date loggedDate;

    public static LoggedRequest createFrom(Request request) {
        LoggedRequest loggedRequest = new LoggedRequest();
        loggedRequest.url = request.getUrl();
        loggedRequest.absoluteUrl = request.getAbsoluteUrl();
        loggedRequest.method = request.getMethod();
        loggedRequest.body = request.getBodyAsString();
        loggedRequest.headers = HttpHeaders.copyOf(request.getHeaders());
        loggedRequest.isBrowserProxyRequest = request.isBrowserProxyRequest();
        loggedRequest.loggedDate = new Date();
        return loggedRequest;
    }

    private LoggedRequest() {
    }

    @JsonCreator
    private LoggedRequest(@JsonProperty(value="url") String url, @JsonProperty(value="absoluteUrl") String absoluteUrl, @JsonProperty(value="method") RequestMethod method, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="body") String body, @JsonProperty(value="browserProxyRequest") boolean isBrowserProxyRequest, @JsonProperty(value="loggedDate") Date loggedDate, @JsonProperty(value="loggedDateString") String loggedDateString) {
        this.url = url;
        this.absoluteUrl = absoluteUrl;
        this.method = method;
        this.body = body;
        this.headers = headers;
        this.isBrowserProxyRequest = isBrowserProxyRequest;
        this.loggedDate = loggedDate;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    @JsonIgnore
    public String getHeader(String key) {
        HttpHeader header = this.header(key);
        if (header.isPresent()) {
            return header.firstValue();
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        for (String currentKey : this.headers.keys()) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            return this.headers.getHeader(currentKey);
        }
        return HttpHeader.absent(key);
    }

    @Override
    public boolean containsHeader(String key) {
        return this.getHeader(key) != null;
    }

    @Override
    @JsonProperty(value="body")
    public String getBodyAsString() {
        return this.body;
    }

    @Override
    @JsonIgnore
    public Set<String> getAllHeaderKeys() {
        return this.headers.keys();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.isBrowserProxyRequest;
    }

    public Date getLoggedDate() {
        return this.loggedDate;
    }

    public String getLoggedDateString() {
        return this.format(this.loggedDate);
    }

    private String format(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }
}

