/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeadersJsonDeserializer;
import com.github.tomakehurst.wiremock.http.HttpHeadersJsonSerializer;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(using=HttpHeadersJsonSerializer.class)
@JsonDeserialize(using=HttpHeadersJsonDeserializer.class)
public class HttpHeaders {
    private final Multimap<String, String> headers = LinkedHashMultimap.create();

    public HttpHeaders() {
    }

    public HttpHeaders(HttpHeader ... headers) {
        this();
        for (HttpHeader header : headers) {
            this.put(header.key(), header.firstValue());
            this.headers.putAll((Object)header.key(), header.values());
        }
    }

    public HttpHeaders(Iterable<HttpHeader> headers) {
        this();
        for (HttpHeader header : headers) {
            this.put(header.key(), header.firstValue());
            this.headers.putAll((Object)header.key(), header.values());
        }
    }

    public HttpHeaders(HttpHeaders headers) {
        this(headers.all());
    }

    public HttpHeader getHeader(String key) {
        if (!this.headers.containsKey((Object)key)) {
            return HttpHeader.absent(key);
        }
        Collection values = this.headers.get((Object)key);
        return new HttpHeader(key, values);
    }

    public boolean hasContentTypeHeader() {
        return this.headers.containsKey((Object)"Content-Type");
    }

    public Collection<HttpHeader> all() {
        ArrayList httpHeaderList = Lists.newArrayList();
        for (String key : this.headers.keySet()) {
            httpHeaderList.add(new HttpHeader(key, this.headers.get((Object)key)));
        }
        return httpHeaderList;
    }

    public String put(String key, String value) {
        this.headers.put((Object)key, (Object)value);
        return value;
    }

    public Set<String> keys() {
        return this.headers.keySet();
    }

    public static HttpHeaders copyOf(HttpHeaders source) {
        return new HttpHeaders(source);
    }

    public int size() {
        return this.headers.asMap().size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeaders that = (HttpHeaders)o;
        return !(this.headers != null ? !this.headers.equals(that.headers) : that.headers != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }
}

