/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.mapping.ResponseDefinition;
import com.google.common.base.Charsets;
import java.nio.charset.Charset;

public class ResponseDefinitionBuilder {
    private int status;
    private byte[] bodyContent;
    private boolean isBinaryBody = false;
    private String bodyFileName;
    private HttpHeaders headers;
    private Integer fixedDelayMilliseconds;
    private String proxyBaseUrl;
    private Fault fault;

    public ResponseDefinitionBuilder withStatus(int status) {
        this.status = status;
        return this;
    }

    public ResponseDefinitionBuilder withHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
        }
        this.headers.put(key, value);
        return this;
    }

    public ResponseDefinitionBuilder withBodyFile(String fileName) {
        this.bodyFileName = fileName;
        return this;
    }

    public ResponseDefinitionBuilder withBody(String body) {
        this.bodyContent = body.getBytes(Charset.forName(Charsets.UTF_8.name()));
        this.isBinaryBody = false;
        return this;
    }

    public ResponseDefinitionBuilder withBody(byte[] body) {
        this.bodyContent = body;
        this.isBinaryBody = true;
        return this;
    }

    public ResponseDefinitionBuilder withFixedDelay(Integer milliseconds) {
        this.fixedDelayMilliseconds = milliseconds;
        return this;
    }

    public ResponseDefinitionBuilder proxiedFrom(String proxyBaseUrl) {
        this.proxyBaseUrl = proxyBaseUrl;
        return this;
    }

    public ResponseDefinitionBuilder withFault(Fault fault) {
        this.fault = fault;
        return this;
    }

    public ResponseDefinition build() {
        ResponseDefinition response = this.isBinaryBody ? new ResponseDefinition(this.status, this.bodyContent) : (this.bodyContent == null ? new ResponseDefinition(this.status, (String)null) : new ResponseDefinition(this.status, new String(this.bodyContent, Charset.forName(Charsets.UTF_8.name()))));
        response.setHeaders(this.headers);
        response.setBodyFileName(this.bodyFileName);
        response.setFixedDelayMilliseconds(this.fixedDelayMilliseconds);
        response.setProxyBaseUrl(this.proxyBaseUrl);
        response.setFault(this.fault);
        return response;
    }
}

