/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ServletContainerUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class Response {
    private int status;
    private byte[] body = new byte[0];
    private HttpHeaders headers = new HttpHeaders();
    private boolean configured = true;
    private Fault fault;
    private boolean fromProxy = false;

    public static Response notConfigured() {
        Response response = new Response(404);
        response.setWasConfigured(false);
        return response;
    }

    public Response(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setBody(String body) {
        if (body == null) {
            return;
        }
        Optional<String> encoding = this.getEncodingFromHeaderIfAvailable();
        this.body = encoding.isPresent() ? body.getBytes(Charset.forName((String)encoding.get())) : body.getBytes(Charsets.UTF_8);
    }

    public void setBody(String body, String charset) {
        if (body == null) {
            return;
        }
        this.body = body.getBytes(Charset.forName(charset));
    }

    public void setBody(byte[] body) {
        if (body == null) {
            return;
        }
        this.body = body;
    }

    public String getBodyAsString() {
        Optional<String> encoding = this.getEncodingFromHeaderIfAvailable();
        if (encoding.isPresent()) {
            return new String(this.body, Charset.forName((String)encoding.get()));
        }
        return new String(this.body, Charsets.UTF_8);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addHeaders(Map<String, String> newHeaders) {
        if (newHeaders != null) {
            this.headers.putAll(newHeaders);
        }
    }

    public void applyTo(HttpServletResponse httpServletResponse) {
        if (this.fault != null) {
            this.fault.apply(httpServletResponse, ServletContainerUtils.getUnderlyingSocketFrom(httpServletResponse));
            return;
        }
        httpServletResponse.setStatus(this.status);
        for (Map.Entry header : this.headers.entrySet()) {
            httpServletResponse.addHeader((String)header.getKey(), (String)header.getValue());
        }
        Response.writeAndTranslateExceptions(httpServletResponse, this.body);
    }

    private static void writeAndTranslateExceptions(HttpServletResponse httpServletResponse, byte[] content) {
        try {
            httpServletResponse.getOutputStream().write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> getEncodingFromHeaderIfAvailable() {
        if (!this.headers.containsKey("Content-Type")) {
            return Optional.absent();
        }
        ContentTypeHeader contentTypeHeader = new ContentTypeHeader((String)this.headers.get("Content-Type"));
        return contentTypeHeader.encodingPart();
    }

    public boolean wasConfigured() {
        return this.configured;
    }

    public void setWasConfigured(boolean configured) {
        this.configured = configured;
    }

    public void setFault(Fault fault) {
        this.fault = fault;
    }

    public boolean isFromProxy() {
        return this.fromProxy;
    }

    public void setFromProxy(boolean fromProxy) {
        this.fromProxy = fromProxy;
    }

    public String toString() {
        return "Response [status=" + this.status + ", body=" + Arrays.toString(this.body) + ", headers=" + this.headers + ", configured=" + this.configured + ", fault=" + (Object)((Object)this.fault) + ", fromProxy=" + this.fromProxy + "]";
    }
}

