/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.mapping.Request;
import com.github.tomakehurst.wiremock.mapping.RequestListener;
import com.github.tomakehurst.wiremock.mapping.RequestPattern;
import com.github.tomakehurst.wiremock.mapping.Response;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.concurrent.ConcurrentLinkedQueue;

public class InMemoryRequestJournal
implements RequestListener,
RequestJournal {
    private ConcurrentLinkedQueue<Request> requests = new ConcurrentLinkedQueue();

    @Override
    public int countRequestsMatching(RequestPattern requestPattern) {
        return Iterables.size((Iterable)Iterables.filter(this.requests, this.matchedBy(requestPattern)));
    }

    private Predicate<Request> matchedBy(final RequestPattern requestPattern) {
        return new Predicate<Request>(){

            public boolean apply(Request input) {
                return requestPattern.isMatchedBy(input);
            }
        };
    }

    @Override
    public void requestReceived(Request request, Response response) {
        this.requests.add(LoggedRequest.createFrom(request));
    }

    @Override
    public void reset() {
        this.requests.clear();
    }
}

