/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class UnevaluatedPropertiesValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnevaluatedPropertiesValidator.class);
    public static final String UNEVALUATED_PROPERTIES = "com.networknt.schema.UnevaluatedPropertiesValidator.UnevaluatedProperties";
    private final JsonSchema schema;

    public UnevaluatedPropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_PROPERTIES, validationContext);
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedProperties' MUST be a valid JSON Schema.");
        }
        this.schema = validationContext.newSchema(schemaPath, schemaNode, parentSchema);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        CollectorContext collectorContext = CollectorContext.getInstance();
        Set<String> allPaths = this.allPaths(node, at);
        Set<String> unevaluatedPaths = UnevaluatedPropertiesValidator.unevaluatedPaths(allPaths);
        HashSet failingPaths = new HashSet();
        unevaluatedPaths.forEach(path -> {
            String pointer = this.getPathType().convertToJsonPointer((String)path);
            JsonNode property = rootNode.at(pointer);
            if (!this.schema.validate(property, rootNode, (String)path).isEmpty()) {
                failingPaths.add(path);
            }
        });
        if (!failingPaths.isEmpty()) {
            collectorContext.add(UNEVALUATED_PROPERTIES, unevaluatedPaths);
            ArrayList paths = new ArrayList(failingPaths);
            paths.sort(String.CASE_INSENSITIVE_ORDER);
            return Collections.singleton(this.buildValidationMessage(String.join((CharSequence)", ", paths), new String[0]));
        }
        collectorContext.getEvaluatedProperties().addAll(allPaths);
        return Collections.emptySet();
    }

    private static Set<String> unevaluatedPaths(Set<String> allPaths) {
        HashSet<String> unevaluatedProperties = new HashSet<String>(allPaths);
        unevaluatedProperties.removeAll(CollectorContext.getInstance().getEvaluatedProperties());
        return unevaluatedProperties;
    }

    private Set<String> allPaths(JsonNode node, String at) {
        HashSet<String> results = new HashSet<String>();
        this.processAllPaths(node, at, results);
        return results;
    }

    private void processAllPaths(JsonNode node, String at, Set<String> paths) {
        Iterator<String> nodesIterator = node.fieldNames();
        while (nodesIterator.hasNext()) {
            String fieldName = nodesIterator.next();
            String path = this.atPath(at, fieldName);
            paths.add(path);
            JsonNode jsonNode = node.get(fieldName);
            if (!jsonNode.isObject()) continue;
            this.processAllPaths(jsonNode, path, paths);
        }
    }
}

