/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class UnevaluatedItemsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnevaluatedItemsValidator.class);
    private final JsonSchema schema;

    public UnevaluatedItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNEVALUATED_ITEMS, validationContext);
        if (!schemaNode.isObject() && !schemaNode.isBoolean()) {
            throw new IllegalArgumentException("The value of 'unevaluatedItems' MUST be a valid JSON Schema.");
        }
        this.schema = validationContext.newSchema(schemaPath, schemaNode, parentSchema);
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        CollectorContext collectorContext = CollectorContext.getInstance();
        Set<String> allPaths = this.allPaths(node, at);
        Set<String> unevaluatedPaths = UnevaluatedItemsValidator.unevaluatedPaths(allPaths);
        HashSet failingPaths = new HashSet();
        unevaluatedPaths.forEach(path -> {
            String pointer = this.getPathType().convertToJsonPointer((String)path);
            JsonNode property = rootNode.at(pointer);
            if (!this.schema.validate(property, rootNode, (String)path).isEmpty()) {
                failingPaths.add(path);
            }
        });
        if (!failingPaths.isEmpty()) {
            ArrayList paths = new ArrayList(failingPaths);
            paths.sort(String.CASE_INSENSITIVE_ORDER);
            return Collections.singleton(this.buildValidationMessage(String.join((CharSequence)", ", paths), new String[0]));
        }
        collectorContext.getEvaluatedItems().addAll(allPaths);
        return Collections.emptySet();
    }

    private Set<String> allPaths(JsonNode node, String at) {
        HashSet<String> results = new HashSet<String>();
        for (int i = 0; i < node.size(); ++i) {
            results.add(this.atPath(at, i));
        }
        return results;
    }

    private static Set<String> unevaluatedPaths(Set<String> allPaths) {
        HashSet<String> unevaluatedProperties = new HashSet<String>(allPaths);
        unevaluatedProperties.removeAll(CollectorContext.getInstance().getEvaluatedItems());
        return unevaluatedProperties;
    }
}

