/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.AbstractFileSource;
import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.common.NotWritableException;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.common.filemaker.FilenameMaker;
import com.github.tomakehurst.wiremock.standalone.MappingFileException;
import com.github.tomakehurst.wiremock.standalone.MappingsSource;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappingCollection;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import wiremock.com.google.common.collect.Iterables;

public class JsonFileMappingsSource
implements MappingsSource {
    private final FileSource mappingsFileSource;
    private final Map<UUID, StubMappingFileMetadata> fileNameMap;
    private final FilenameMaker filenameMaker;

    public JsonFileMappingsSource(FileSource mappingsFileSource, FilenameMaker filenameMaker) {
        this.mappingsFileSource = mappingsFileSource;
        this.filenameMaker = Objects.requireNonNullElseGet(filenameMaker, FilenameMaker::new);
        this.fileNameMap = new HashMap<UUID, StubMappingFileMetadata>();
    }

    @Override
    public void save(List<StubMapping> stubMappings) {
        for (StubMapping mapping : stubMappings) {
            if (mapping == null || !mapping.isDirty()) continue;
            this.save(mapping);
        }
    }

    @Override
    public void save(StubMapping stubMapping) {
        StubMappingFileMetadata fileMetadata = this.fileNameMap.get(stubMapping.getId());
        if (fileMetadata == null) {
            fileMetadata = new StubMappingFileMetadata(this.filenameMaker.filenameFor(stubMapping), false);
        }
        if (fileMetadata.multi) {
            throw new NotWritableException("Stubs loaded from multi-mapping files are read-only, and therefore cannot be saved");
        }
        this.mappingsFileSource.writeTextFile(fileMetadata.path, Json.writePrivate(stubMapping));
        this.fileNameMap.put(stubMapping.getId(), fileMetadata);
        stubMapping.setDirty(false);
    }

    @Override
    public void remove(StubMapping stubMapping) {
        StubMappingFileMetadata fileMetadata = this.fileNameMap.get(stubMapping.getId());
        if (fileMetadata.multi) {
            throw new NotWritableException("Stubs loaded from multi-mapping files are read-only, and therefore cannot be removed");
        }
        this.mappingsFileSource.deleteFile(fileMetadata.path);
        this.fileNameMap.remove(stubMapping.getId());
    }

    @Override
    public void removeAll() {
        if (this.anyFilesAreMultiMapping()) {
            throw new NotWritableException("Some stubs were loaded from multi-mapping files which are read-only, so remove all cannot be performed");
        }
        for (StubMappingFileMetadata fileMetadata : this.fileNameMap.values()) {
            this.mappingsFileSource.deleteFile(fileMetadata.path);
        }
        this.fileNameMap.clear();
    }

    private boolean anyFilesAreMultiMapping() {
        return Iterables.any(this.fileNameMap.values(), input -> input.multi);
    }

    @Override
    public void loadMappingsInto(StubMappings stubMappings) {
        if (!this.mappingsFileSource.exists()) {
            return;
        }
        Iterable<BinaryFile> mappingFiles = Iterables.filter(this.mappingsFileSource.listFilesRecursively(), AbstractFileSource.byFileExtension("json"));
        for (TextFile textFile : mappingFiles) {
            try {
                StubMappingCollection stubCollection = Json.read(textFile.readContentsAsString(), StubMappingCollection.class);
                for (StubMapping stubMapping : stubCollection.getMappingOrMappings()) {
                    stubMapping.setDirty(false);
                    stubMappings.addMapping(stubMapping);
                    StubMappingFileMetadata fileMetadata = new StubMappingFileMetadata(textFile.getPath(), stubCollection.isMulti());
                    this.fileNameMap.put(stubMapping.getId(), fileMetadata);
                }
            }
            catch (JsonException e) {
                throw new MappingFileException(textFile.getPath(), e.getErrors().first().getDetail());
            }
        }
    }

    private static class StubMappingFileMetadata {
        final String path;
        final boolean multi;

        public StubMappingFileMetadata(String path, boolean multi) {
            this.path = path;
            this.multi = multi;
        }
    }
}

