/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import java.io.IOException;
import java.util.Collection;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.io.ByteStreams;
import wiremock.jakarta.servlet.http.Part;

public class WireMockHttpServletMultipartAdapter
implements Request.Part {
    private final Part mPart;
    private final HttpHeaders headers;

    public WireMockHttpServletMultipartAdapter(final Part servletPart) {
        this.mPart = servletPart;
        FluentIterable<HttpHeader> httpHeaders = FluentIterable.from(this.mPart.getHeaderNames()).transform(new Function<String, HttpHeader>(){

            @Override
            public HttpHeader apply(String name) {
                Collection<String> headerValues = servletPart.getHeaders(name);
                return HttpHeader.httpHeader(name, headerValues.toArray(new String[headerValues.size()]));
            }
        });
        this.headers = new HttpHeaders(httpHeaders);
    }

    public static WireMockHttpServletMultipartAdapter from(Part servletPart) {
        return new WireMockHttpServletMultipartAdapter(servletPart);
    }

    @Override
    public String getName() {
        return this.mPart.getName();
    }

    @Override
    public HttpHeader getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public Body getBody() {
        try {
            byte[] bytes = ByteStreams.toByteArray(this.mPart.getInputStream());
            HttpHeader header = this.getHeader("Content-Type");
            ContentTypeHeader contentTypeHeader = header.isPresent() ? new ContentTypeHeader(header.firstValue()) : ContentTypeHeader.absent();
            return Body.ofBinaryOrText(bytes, contentTypeHeader);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, Body.class);
        }
    }
}

