/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.diff;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import wiremock.org.xmlunit.diff.ElementSelector;
import wiremock.org.xmlunit.diff.ElementSelectors;

public class MultiLevelByNameAndTextSelector
implements ElementSelector {
    private final int levels;
    private final boolean ignoreEmptyTexts;

    public MultiLevelByNameAndTextSelector(int levels) {
        this(levels, false);
    }

    public MultiLevelByNameAndTextSelector(int levels, boolean ignoreEmptyTexts) {
        if (levels < 1) {
            throw new IllegalArgumentException("levels must be equal or greater than one");
        }
        this.levels = levels;
        this.ignoreEmptyTexts = ignoreEmptyTexts;
    }

    @Override
    public boolean canBeCompared(Element controlElement, Element testElement) {
        Element currentControl = controlElement;
        Element currentTest = testElement;
        for (int currentLevel = 0; currentLevel <= this.levels - 2; ++currentLevel) {
            if (!(ElementSelectors.byName.canBeCompared(currentControl, currentTest) && currentControl.hasChildNodes() && currentTest.hasChildNodes())) {
                return false;
            }
            Node n1 = this.getFirstEligibleChild(currentControl);
            Node n2 = this.getFirstEligibleChild(currentTest);
            if (n1.getNodeType() != 1 || n2.getNodeType() != 1) {
                return false;
            }
            currentControl = (Element)n1;
            currentTest = (Element)n2;
        }
        return ElementSelectors.byNameAndText.canBeCompared(currentControl, currentTest);
    }

    private Node getFirstEligibleChild(Node parent) {
        Node n1 = parent.getFirstChild();
        if (this.ignoreEmptyTexts) {
            Node n2;
            while (MultiLevelByNameAndTextSelector.isText(n1) && n1.getNodeValue().trim().length() == 0 && (n2 = n1.getNextSibling()) != null) {
                n1 = n2;
            }
        }
        return n1;
    }

    private static boolean isText(Node n) {
        return n instanceof Text;
    }
}

