/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.recording.SnapshotRecordResultDeserialiser;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.collect.Lists;

@JsonDeserialize(using=SnapshotRecordResultDeserialiser.class)
public class SnapshotRecordResult {
    protected final List<StubMapping> stubMappings;

    protected SnapshotRecordResult(List<StubMapping> mappings) {
        this.stubMappings = mappings;
    }

    @JsonIgnore
    public List<StubMapping> getStubMappings() {
        return this.stubMappings;
    }

    public static SnapshotRecordResult full(List<StubMapping> stubMappings) {
        return new Full(stubMappings);
    }

    public static SnapshotRecordResult idsFromMappings(List<StubMapping> stubMappings) {
        return new Ids(Lists.transform(stubMappings, new Function<StubMapping, UUID>(){

            @Override
            public UUID apply(StubMapping input) {
                return input.getId();
            }
        }));
    }

    public static SnapshotRecordResult ids(List<UUID> ids) {
        return new Ids(ids);
    }

    public static SnapshotRecordResult empty() {
        return SnapshotRecordResult.full(Collections.emptyList());
    }

    public static class Full
    extends SnapshotRecordResult {
        public Full(List<StubMapping> mappings) {
            super(mappings);
        }

        public List<StubMapping> getMappings() {
            return this.stubMappings;
        }
    }

    public static class Ids
    extends SnapshotRecordResult {
        private final List<UUID> ids;

        public Ids(List<UUID> ids) {
            super(Collections.emptyList());
            this.ids = ids;
        }

        public List<UUID> getIds() {
            return this.ids;
        }
    }
}

