/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.common.Dates;
import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.google.common.base.Charsets;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.FluentIterable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoggedRequest
implements Request {
    private final String scheme;
    private final String host;
    private final int port;
    private final String url;
    private final String absoluteUrl;
    private final String clientIp;
    private final RequestMethod method;
    private final HttpHeaders headers;
    private final Map<String, Cookie> cookies;
    private final Map<String, QueryParameter> queryParams;
    private final byte[] body;
    private final boolean isBrowserProxyRequest;
    private final Date loggedDate;
    private final Collection<Request.Part> multiparts;
    private final String protocol;

    public static LoggedRequest createFrom(Request request) {
        return new LoggedRequest(request.getUrl(), request.getAbsoluteUrl(), request.getMethod(), request.getClientIp(), request.getHeaders(), request.getCookies(), request.isBrowserProxyRequest(), new Date(), request.getBody(), request.getParts(), request.getProtocol());
    }

    @JsonCreator
    public LoggedRequest(@JsonProperty(value="url") String url, @JsonProperty(value="absoluteUrl") String absoluteUrl, @JsonProperty(value="method") RequestMethod method, @JsonProperty(value="clientIp") String clientIp, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="cookies") Map<String, Cookie> cookies, @JsonProperty(value="browserProxyRequest") boolean isBrowserProxyRequest, @JsonProperty(value="loggedDate") Date loggedDate, @JsonProperty(value="bodyAsBase64") String bodyAsBase64, @JsonProperty(value="body") String ignoredBodyOnlyUsedForBinding, @JsonProperty(value="multiparts") Collection<Request.Part> multiparts, @JsonProperty(value="protocol") String protocol) {
        this(url, absoluteUrl, method, clientIp, headers, cookies, isBrowserProxyRequest, loggedDate, Encoding.decodeBase64(bodyAsBase64), multiparts, protocol);
    }

    public LoggedRequest(String url, String absoluteUrl, RequestMethod method, String clientIp, HttpHeaders headers, Map<String, Cookie> cookies, boolean isBrowserProxyRequest, Date loggedDate, byte[] body, Collection<Request.Part> multiparts, String protocol) {
        this.url = url;
        this.absoluteUrl = absoluteUrl;
        if (absoluteUrl == null) {
            this.scheme = null;
            this.host = null;
            this.port = -1;
        } else {
            URL fullUrl = Urls.safelyCreateURL(absoluteUrl);
            this.scheme = fullUrl.getProtocol();
            this.host = fullUrl.getHost();
            this.port = fullUrl.getPort();
        }
        this.clientIp = clientIp;
        this.method = method;
        this.body = body;
        this.headers = headers;
        this.cookies = cookies;
        this.queryParams = Urls.splitQueryFromUrl(url);
        this.isBrowserProxyRequest = isBrowserProxyRequest;
        this.loggedDate = loggedDate;
        this.multiparts = multiparts;
        this.protocol = protocol;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getClientIp() {
        return this.clientIp;
    }

    @Override
    @JsonIgnore
    public String getHeader(String key) {
        HttpHeader header = this.header(key);
        if (header.isPresent()) {
            return header.firstValue();
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        return this.headers.getHeader(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        if (this.headers != null) {
            return this.headers.getContentTypeHeader();
        }
        return null;
    }

    private Charset encodingFromContentTypeHeaderOrUtf8() {
        ContentTypeHeader contentTypeHeader = this.contentTypeHeader();
        if (contentTypeHeader != null) {
            return contentTypeHeader.charset();
        }
        return Charsets.UTF_8;
    }

    @Override
    public boolean containsHeader(String key) {
        return this.getHeader(key) != null;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    @JsonProperty(value="body")
    public String getBodyAsString() {
        return Strings.stringFromBytes(this.body, this.encodingFromContentTypeHeaderOrUtf8());
    }

    @Override
    @JsonProperty(value="bodyAsBase64")
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.body);
    }

    @Override
    @JsonIgnore
    public Set<String> getAllHeaderKeys() {
        return this.headers.keys();
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return MoreObjects.firstNonNull(this.queryParams.get(key), QueryParameter.absent(key));
    }

    @JsonProperty(value="queryParams")
    public Map<String, QueryParameter> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.isBrowserProxyRequest;
    }

    @Override
    @JsonIgnore
    public Optional<Request> getOriginalRequest() {
        return Optional.absent();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public Date getLoggedDate() {
        return this.loggedDate;
    }

    public String getLoggedDateString() {
        return this.loggedDate != null ? Dates.format(this.loggedDate) : null;
    }

    public String toString() {
        return Json.write(this);
    }

    @Override
    @JsonIgnore
    public boolean isMultipart() {
        return this.multiparts != null && this.multiparts.size() > 0;
    }

    @Override
    @JsonIgnore
    public Collection<Request.Part> getParts() {
        return this.multiparts;
    }

    @Override
    @JsonIgnore
    public Request.Part getPart(final String name) {
        return this.multiparts != null && name != null ? FluentIterable.from(this.multiparts).firstMatch(new Predicate<Request.Part>(){

            @Override
            public boolean apply(Request.Part input) {
                return name.equals(input.getName());
            }
        }).get() : null;
    }
}

