/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.InputStreamSource;
import com.github.tomakehurst.wiremock.common.Limit;
import com.github.tomakehurst.wiremock.common.StreamSources;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.io.ByteStreams;

public class Response {
    private final int status;
    private final String statusMessage;
    private final InputStreamSource bodyStreamSource;
    private final HttpHeaders headers;
    private final boolean configured;
    private final Fault fault;
    private final boolean fromProxy;
    private final long initialDelay;
    private final ChunkedDribbleDelay chunkedDribbleDelay;
    private final String protocol;

    public static Response notConfigured() {
        return new Response(404, null, StreamSources.empty(), HttpHeaders.noHeaders(), false, null, 0L, null, false, null);
    }

    public static Builder response() {
        return new Builder();
    }

    private Response(int status, String statusMessage, InputStreamSource bodyStreamSource, HttpHeaders headers, boolean configured, Fault fault, long initialDelay, ChunkedDribbleDelay chunkedDribbleDelay, boolean fromProxy, String protocol) {
        this.status = status;
        this.statusMessage = statusMessage;
        this.bodyStreamSource = bodyStreamSource;
        this.headers = headers;
        this.configured = configured;
        this.fault = fault;
        this.initialDelay = initialDelay;
        this.chunkedDribbleDelay = chunkedDribbleDelay;
        this.fromProxy = fromProxy;
        this.protocol = protocol;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public byte[] getBody() {
        return this.getBody(Limit.UNLIMITED);
    }

    public byte[] getBody(Limit sizeLimit) {
        return Exceptions.uncheck(() -> Response.getBytesFromStream(this.bodyStreamSource, sizeLimit), byte[].class);
    }

    private static byte[] getBytesFromStream(InputStreamSource streamSource, Limit limit) throws IOException {
        try (InputStream stream = streamSource == null ? null : streamSource.getStream();){
            if (stream == null) {
                byte[] byArray = null;
                return byArray;
            }
            InputStream trimmedStream = limit != null && !limit.isUnlimited() ? ByteStreams.limit(stream, limit.getValue().intValue()) : stream;
            byte[] byArray = ByteStreams.toByteArray(trimmedStream);
            return byArray;
        }
    }

    public String getBodyAsString() {
        return Strings.stringFromBytes(this.getBody(), this.headers.getContentTypeHeader().charset());
    }

    public InputStream getBodyStream() {
        return this.bodyStreamSource == null ? null : this.bodyStreamSource.getStream();
    }

    public boolean hasInlineBody() {
        return StreamSources.ByteArrayInputStreamSource.class.isAssignableFrom(this.bodyStreamSource.getClass());
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Fault getFault() {
        return this.fault;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public ChunkedDribbleDelay getChunkedDribbleDelay() {
        return this.chunkedDribbleDelay;
    }

    public boolean shouldAddChunkedDribbleDelay() {
        return this.chunkedDribbleDelay != null;
    }

    public boolean wasConfigured() {
        return this.configured;
    }

    public boolean isFromProxy() {
        return this.fromProxy;
    }

    public String toString() {
        return this.protocol + " " + this.status + "\n" + this.headers;
    }

    public static class Builder {
        private int status = 200;
        private String statusMessage;
        private byte[] bodyBytes;
        private String bodyString;
        private InputStreamSource bodyStream;
        private HttpHeaders headers = new HttpHeaders();
        private boolean configured = true;
        private Fault fault;
        private boolean fromProxy;
        private long initialDelay;
        private ChunkedDribbleDelay chunkedDribbleDelay;
        private String protocol;

        public static Builder like(Response response) {
            Builder responseBuilder = new Builder();
            responseBuilder.status = response.getStatus();
            responseBuilder.statusMessage = response.getStatusMessage();
            responseBuilder.bodyStream = response.bodyStreamSource;
            responseBuilder.headers = response.getHeaders();
            responseBuilder.configured = response.wasConfigured();
            responseBuilder.fault = response.getFault();
            responseBuilder.initialDelay = response.getInitialDelay();
            responseBuilder.chunkedDribbleDelay = response.getChunkedDribbleDelay();
            responseBuilder.fromProxy = response.isFromProxy();
            return responseBuilder;
        }

        public Builder but() {
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder body(byte[] body) {
            this.bodyBytes = body;
            this.bodyString = null;
            this.bodyStream = null;
            return this;
        }

        public Builder body(String body) {
            this.bodyBytes = null;
            this.bodyString = body;
            this.bodyStream = null;
            return this;
        }

        public Builder body(InputStreamSource bodySource) {
            this.bodyBytes = null;
            this.bodyString = null;
            this.bodyStream = bodySource;
            return this;
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers == null ? HttpHeaders.noHeaders() : headers;
            return this;
        }

        public Builder configured(boolean configured) {
            this.configured = configured;
            return this;
        }

        public Builder fault(Fault fault) {
            this.fault = fault;
            return this;
        }

        public Builder configureDelay(Integer globalFixedDelay, DelayDistribution globalDelayDistribution, Integer fixedDelay, DelayDistribution delayDistribution) {
            this.addDelayIfSpecifiedGloballyOrIn(fixedDelay, globalFixedDelay);
            this.addRandomDelayIfSpecifiedGloballyOrIn(delayDistribution, globalDelayDistribution);
            return this;
        }

        private void addDelayIfSpecifiedGloballyOrIn(Integer fixedDelay, Integer globalFixedDelay) {
            Optional<Integer> optionalDelay = this.getDelayFromResponseOrGlobalSetting(fixedDelay, globalFixedDelay);
            if (optionalDelay.isPresent()) {
                this.incrementInitialDelay(optionalDelay.get().intValue());
            }
        }

        private Optional<Integer> getDelayFromResponseOrGlobalSetting(Integer fixedDelay, Integer globalFixedDelay) {
            Integer delay = fixedDelay != null ? fixedDelay : globalFixedDelay;
            return Optional.fromNullable(delay);
        }

        private void addRandomDelayIfSpecifiedGloballyOrIn(DelayDistribution localDelayDistribution, DelayDistribution globalDelayDistribution) {
            DelayDistribution delayDistribution = localDelayDistribution != null ? localDelayDistribution : globalDelayDistribution;
            if (delayDistribution != null) {
                this.incrementInitialDelay(delayDistribution.sampleMillis());
            }
        }

        public Builder incrementInitialDelay(long amountMillis) {
            this.initialDelay += amountMillis;
            return this;
        }

        public Builder chunkedDribbleDelay(ChunkedDribbleDelay chunkedDribbleDelay) {
            this.chunkedDribbleDelay = chunkedDribbleDelay;
            return this;
        }

        public Builder fromProxy(boolean fromProxy) {
            this.fromProxy = fromProxy;
            return this;
        }

        public Response build() {
            InputStreamSource bodyStream = this.bodyBytes != null ? StreamSources.forBytes(this.bodyBytes) : (this.bodyString != null ? StreamSources.forString(this.bodyString, this.headers.getContentTypeHeader().charset()) : (this.bodyStream != null ? this.bodyStream : StreamSources.empty()));
            return new Response(this.status, this.statusMessage, bodyStream, this.headers, this.configured, this.fault, this.initialDelay, this.chunkedDribbleDelay, this.fromProxy, this.protocol);
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }
    }
}

