/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.helper;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.Options;
import wiremock.com.github.jknack.handlebars.TagType;

public class LogHelper
implements Helper<Object> {
    public static final Helper<Object> INSTANCE = new LogHelper();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "log";

    @Override
    public Object apply(Object context, Options options) throws IOException {
        StringBuilder sb = new StringBuilder();
        String level = (String)options.hash("level", "info");
        TagType tagType = options.tagType;
        if (tagType.inline()) {
            sb.append(context);
            for (int i = 0; i < options.params.length; ++i) {
                sb.append(" ").append(options.param(i));
            }
        } else {
            sb.append(options.fn());
        }
        switch (level) {
            case "error": {
                this.log.error(sb.toString().trim());
                break;
            }
            case "debug": {
                this.log.debug(sb.toString().trim());
                break;
            }
            case "warn": {
                this.log.warn(sb.toString().trim());
                break;
            }
            case "trace": {
                this.log.trace(sb.toString().trim());
                break;
            }
            default: {
                this.log.info(sb.toString().trim());
            }
        }
        return null;
    }
}

