/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.validation;

import org.xml.sax.SAXParseException;

public class ValidationProblem {
    public static final int UNKNOWN = -1;
    private final int line;
    private final int column;
    private final ProblemType type;
    private final String message;

    public ValidationProblem(String message, int line, int column, ProblemType type) {
        this.message = message;
        this.line = line;
        this.column = column;
        this.type = type;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public ProblemType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValidationProblem { ");
        sb.append("line=").append(this.line);
        sb.append(", column=").append(this.column);
        sb.append(", type=").append((Object)this.type);
        sb.append(", message='").append(this.message).append('\'');
        sb.append(" }");
        return sb.toString();
    }

    static ValidationProblem fromException(SAXParseException e, ProblemType type) {
        return new ValidationProblem(e.getMessage(), e.getLineNumber() > 0 ? e.getLineNumber() : -1, e.getColumnNumber() > 0 ? e.getColumnNumber() : -1, type);
    }

    public static enum ProblemType {
        ERROR,
        WARNING;

    }
}

