/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.io.IOException;
import wiremock.com.google.common.base.Charsets;
import wiremock.org.apache.http.HttpEntity;
import wiremock.org.apache.http.HttpResponse;
import wiremock.org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    public static String getEntityAsStringAndCloseStream(HttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                String content = EntityUtils.toString(entity, Charsets.UTF_8.name());
                entity.getContent().close();
                return content;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return null;
    }

    public static byte[] getEntityAsByteArrayAndCloseStream(HttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                byte[] content = EntityUtils.toByteArray(entity);
                entity.getContent().close();
                return content;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return null;
    }
}

