/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.StubMappingTransformer;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;
import wiremock.com.google.common.base.Function;

public class SnapshotStubMappingTransformerRunner
implements Function<StubMapping, StubMapping> {
    private final FileSource filesRoot;
    private final Parameters parameters;
    private final Iterable<StubMappingTransformer> registeredTransformers;
    private final List<String> requestedTransformers;

    public SnapshotStubMappingTransformerRunner(Iterable<StubMappingTransformer> registeredTransformers) {
        this(registeredTransformers, null, null, null);
    }

    public SnapshotStubMappingTransformerRunner(Iterable<StubMappingTransformer> registeredTransformers, List<String> requestedTransformers, Parameters parameters, FileSource filesRoot) {
        this.requestedTransformers = requestedTransformers;
        this.registeredTransformers = registeredTransformers;
        this.parameters = parameters;
        this.filesRoot = filesRoot;
    }

    @Override
    public StubMapping apply(StubMapping stubMapping) {
        for (StubMappingTransformer transformer : this.registeredTransformers) {
            if (!transformer.applyGlobally() && (this.requestedTransformers == null || !this.requestedTransformers.contains(transformer.getName()))) continue;
            stubMapping = transformer.transform(stubMapping, this.filesRoot, this.parameters);
        }
        return stubMapping;
    }
}

