/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.flipkart.zjsonpatch;

import java.util.EnumSet;
import java.util.List;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.NullNode;
import wiremock.com.flipkart.zjsonpatch.ApplyProcessor;
import wiremock.com.flipkart.zjsonpatch.CompatibilityFlags;
import wiremock.com.flipkart.zjsonpatch.Constants;
import wiremock.com.flipkart.zjsonpatch.InvalidJsonPatchException;
import wiremock.com.flipkart.zjsonpatch.JsonPatchApplicationException;
import wiremock.com.flipkart.zjsonpatch.JsonPatchProcessor;
import wiremock.com.flipkart.zjsonpatch.NoopProcessor;
import wiremock.com.flipkart.zjsonpatch.Operation;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.Splitter;
import wiremock.com.google.common.collect.Iterables;
import wiremock.com.google.common.collect.Lists;

public final class JsonPatch {
    private static final DecodePathFunction DECODE_PATH_FUNCTION = new DecodePathFunction();

    private JsonPatch() {
    }

    private static JsonNode getPatchAttr(JsonNode jsonNode, String attr) {
        JsonNode child = jsonNode.get(attr);
        if (child == null) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (missing '" + attr + "' field)");
        }
        return child;
    }

    private static JsonNode getPatchAttrWithDefault(JsonNode jsonNode, String attr, JsonNode defaultValue) {
        JsonNode child = jsonNode.get(attr);
        if (child == null) {
            return defaultValue;
        }
        return child;
    }

    private static void process(JsonNode patch, JsonPatchProcessor processor, EnumSet<CompatibilityFlags> flags) throws InvalidJsonPatchException {
        if (!patch.isArray()) {
            throw new InvalidJsonPatchException("Invalid JSON Patch payload (not an array)");
        }
        for (JsonNode jsonNode : patch) {
            if (!jsonNode.isObject()) {
                throw new InvalidJsonPatchException("Invalid JSON Patch payload (not an object)");
            }
            Operation operation = Operation.fromRfcName(JsonPatch.getPatchAttr(jsonNode, Constants.OP).toString().replaceAll("\"", ""));
            List<String> path = JsonPatch.getPath(JsonPatch.getPatchAttr(jsonNode, Constants.PATH));
            switch (operation) {
                case REMOVE: {
                    processor.remove(path);
                    break;
                }
                case ADD: {
                    JsonNode value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, Constants.VALUE) : JsonPatch.getPatchAttrWithDefault(jsonNode, Constants.VALUE, NullNode.getInstance());
                    processor.add(path, value);
                    break;
                }
                case REPLACE: {
                    JsonNode value = !flags.contains((Object)CompatibilityFlags.MISSING_VALUES_AS_NULLS) ? JsonPatch.getPatchAttr(jsonNode, Constants.VALUE) : JsonPatch.getPatchAttrWithDefault(jsonNode, Constants.VALUE, NullNode.getInstance());
                    processor.replace(path, value);
                    break;
                }
                case MOVE: {
                    List<String> fromPath = JsonPatch.getPath(JsonPatch.getPatchAttr(jsonNode, Constants.FROM));
                    processor.move(fromPath, path);
                    break;
                }
            }
        }
    }

    public static void validate(JsonNode patch, EnumSet<CompatibilityFlags> flags) throws InvalidJsonPatchException {
        JsonPatch.process(patch, NoopProcessor.INSTANCE, flags);
    }

    public static void validate(JsonNode patch) throws InvalidJsonPatchException {
        JsonPatch.validate(patch, CompatibilityFlags.defaults());
    }

    public static JsonNode apply(JsonNode patch, JsonNode source, EnumSet<CompatibilityFlags> flags) throws JsonPatchApplicationException {
        ApplyProcessor processor = new ApplyProcessor(source);
        JsonPatch.process(patch, processor, flags);
        return processor.result();
    }

    public static JsonNode apply(JsonNode patch, JsonNode source) throws JsonPatchApplicationException {
        return JsonPatch.apply(patch, source, CompatibilityFlags.defaults());
    }

    private static List<String> getPath(JsonNode path) {
        List<String> paths = Splitter.on('/').splitToList(path.toString().replaceAll("\"", ""));
        return Lists.newArrayList(Iterables.transform(paths, DECODE_PATH_FUNCTION));
    }

    private static final class DecodePathFunction
    implements Function<String, String> {
        private DecodePathFunction() {
        }

        @Override
        public String apply(String path) {
            return path.replaceAll("~1", "/").replaceAll("~0", "~");
        }
    }
}

