/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit.jaxp13;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlunit.XMLUnitException;
import org.xmlunit.xpath.JAXPXPathEngine;
import wiremock.org.custommonkey.xmlunit.NamespaceContext;
import wiremock.org.custommonkey.xmlunit.XMLUnit;
import wiremock.org.custommonkey.xmlunit.XpathEngine;
import wiremock.org.custommonkey.xmlunit.exceptions.ConfigurationException;
import wiremock.org.custommonkey.xmlunit.exceptions.XpathException;
import wiremock.org.custommonkey.xmlunit.jaxp13.XMLUnitNamespaceContext2Jaxp13;

public class Jaxp13XpathEngine
implements XpathEngine {
    private final JAXPXPathEngine engine;

    public Jaxp13XpathEngine() throws ConfigurationException {
        try {
            JAXPXPathEngine e = null;
            e = XMLUnit.getXPathFactory() != null ? new JAXPXPathEngine((XPathFactory)Class.forName(XMLUnit.getXPathFactory()).newInstance()) : new JAXPXPathEngine();
            this.engine = e;
        }
        catch (org.xmlunit.ConfigurationException ex) {
            throw new ConfigurationException(ex.getCause());
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
    }

    @Override
    public NodeList getMatchingNodes(String select, Document document) throws XpathException {
        try {
            return new NodeListForIterable(this.engine.selectNodes(select, new DOMSource(document)));
        }
        catch (XMLUnitException ex) {
            throw new XpathException(ex.getCause());
        }
    }

    @Override
    public String evaluate(String select, Document document) throws XpathException {
        try {
            return this.engine.evaluate(select, new DOMSource(document));
        }
        catch (XMLUnitException ex) {
            throw new XpathException(ex.getCause());
        }
    }

    @Override
    public void setNamespaceContext(NamespaceContext ctx) {
        this.engine.setNamespaceContext(XMLUnitNamespaceContext2Jaxp13.turnIntoMap(ctx));
    }

    private static class NodeListForIterable
    implements NodeList {
        private final List<Node> l;

        private NodeListForIterable(Iterable<Node> it) {
            ArrayList<Node> a = new ArrayList<Node>();
            for (Node n : it) {
                a.add(n);
            }
            this.l = Collections.unmodifiableList(a);
        }

        @Override
        public int getLength() {
            return this.l.size();
        }

        @Override
        public Node item(int idx) {
            return this.l.get(idx);
        }
    }
}

