/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.internal.token;

import java.util.List;
import wiremock.com.jayway.jsonpath.InvalidPathException;
import wiremock.com.jayway.jsonpath.Option;
import wiremock.com.jayway.jsonpath.PathNotFoundException;
import wiremock.com.jayway.jsonpath.internal.PathRef;
import wiremock.com.jayway.jsonpath.internal.Utils;
import wiremock.com.jayway.jsonpath.internal.token.EvaluationContextImpl;
import wiremock.com.jayway.jsonpath.spi.json.JsonProvider;

public abstract class PathToken {
    private PathToken prev;
    private PathToken next;
    private Boolean definite = null;
    private Boolean upstreamDefinite = null;

    PathToken appendTailToken(PathToken next) {
        this.next = next;
        this.next.prev = this;
        return next;
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleObjectProperty(String currentPath, Object model, EvaluationContextImpl ctx, List<String> properties) {
        if (properties.size() == 1) {
            PathRef pathRef;
            String property = properties.get(0);
            String evalPath = currentPath + "['" + property + "']";
            Object propertyVal = PathToken.readObjectProperty(property, model, ctx);
            if (propertyVal == JsonProvider.UNDEFINED) {
                if (!this.isLeaf()) {
                    if (this.isUpstreamDefinite()) throw new PathNotFoundException("Missing property in path " + evalPath);
                    if (ctx.options().contains((Object)Option.REQUIRE_PROPERTIES)) throw new PathNotFoundException("Missing property in path " + evalPath);
                    if (ctx.options().contains((Object)Option.SUPPRESS_EXCEPTIONS)) throw new PathNotFoundException("Missing property in path " + evalPath);
                    return;
                }
                if (!ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
                    if (!ctx.options().contains((Object)Option.SUPPRESS_EXCEPTIONS)) throw new PathNotFoundException("No results for path: " + evalPath);
                    if (ctx.options().contains((Object)Option.REQUIRE_PROPERTIES)) throw new PathNotFoundException("No results for path: " + evalPath);
                    return;
                }
                propertyVal = null;
            }
            PathRef pathRef2 = pathRef = ctx.forUpdate() ? PathRef.create(model, property) : PathRef.NO_OP;
            if (this.isLeaf()) {
                ctx.addResult(evalPath, pathRef, propertyVal);
                return;
            }
            this.next().evaluate(evalPath, pathRef, propertyVal, ctx);
            return;
        }
        String evalPath = currentPath + "[" + Utils.join(", ", "'", properties) + "]";
        if (!this.isLeaf()) {
            throw new InvalidPathException("Multi properties can only be used as path leafs: " + evalPath);
        }
        Object merged = ctx.jsonProvider().createMap();
        for (String property : properties) {
            Object propertyVal;
            if (PathToken.hasProperty(property, model, ctx)) {
                propertyVal = PathToken.readObjectProperty(property, model, ctx);
                if (propertyVal == JsonProvider.UNDEFINED) {
                    if (!ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) continue;
                    propertyVal = null;
                }
            } else if (ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
                propertyVal = null;
            } else {
                if (!ctx.options().contains((Object)Option.REQUIRE_PROPERTIES)) continue;
                throw new PathNotFoundException("Missing property in path " + evalPath);
            }
            ctx.jsonProvider().setProperty(merged, property, propertyVal);
        }
        PathRef pathRef = ctx.forUpdate() ? PathRef.create(model, properties) : PathRef.NO_OP;
        ctx.addResult(evalPath, pathRef, merged);
    }

    private static boolean hasProperty(String property, Object model, EvaluationContextImpl ctx) {
        return ctx.jsonProvider().getPropertyKeys(model).contains(property);
    }

    private static Object readObjectProperty(String property, Object model, EvaluationContextImpl ctx) {
        return ctx.jsonProvider().getMapValue(model, property);
    }

    void handleArrayIndex(int index, String currentPath, Object model, EvaluationContextImpl ctx) {
        String evalPath = currentPath + "[" + index + "]";
        PathRef pathRef = ctx.forUpdate() ? PathRef.create(model, index) : PathRef.NO_OP;
        try {
            Object evalHit = ctx.jsonProvider().getArrayIndex(model, index);
            if (this.isLeaf()) {
                ctx.addResult(evalPath, pathRef, evalHit);
            } else {
                this.next().evaluate(evalPath, pathRef, evalHit, ctx);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new PathNotFoundException("Index out of bounds when evaluating path " + evalPath);
        }
    }

    PathToken prev() {
        return this.prev;
    }

    PathToken next() {
        if (this.isLeaf()) {
            throw new IllegalStateException("Current path token is a leaf");
        }
        return this.next;
    }

    boolean isLeaf() {
        return this.next == null;
    }

    boolean isRoot() {
        return this.prev == null;
    }

    boolean isUpstreamDefinite() {
        if (this.upstreamDefinite != null) {
            return this.upstreamDefinite;
        }
        boolean isUpstreamDefinite = this.isTokenDefinite();
        if (isUpstreamDefinite && !this.isRoot()) {
            isUpstreamDefinite = this.prev.isPathDefinite();
        }
        this.upstreamDefinite = isUpstreamDefinite;
        return isUpstreamDefinite;
    }

    public int getTokenCount() {
        int cnt = 1;
        PathToken token = this;
        while (!token.isLeaf()) {
            token = token.next();
            ++cnt;
        }
        return cnt;
    }

    public boolean isPathDefinite() {
        if (this.definite != null) {
            return this.definite;
        }
        boolean isDefinite = this.isTokenDefinite();
        if (isDefinite && !this.isLeaf()) {
            isDefinite = this.next.isPathDefinite();
        }
        this.definite = isDefinite;
        return isDefinite;
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.getPathFragment();
        }
        return this.getPathFragment() + this.next().toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public abstract void evaluate(String var1, PathRef var2, Object var3, EvaluationContextImpl var4);

    abstract boolean isTokenDefinite();

    abstract String getPathFragment();
}

