/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.ValueAnimatorCompat;
import android.support.design.widget.ViewUtils;
import android.util.AttributeSet;
import android.view.View;
import java.lang.reflect.Field;

public class AppBarFlingFixBehavior
extends AppBarLayout.Behavior {
    private static final int MAX_OFFSET_ANIMATION_DURATION = 600;
    private ValueAnimatorCompat mOffsetAnimator;

    public AppBarFlingFixBehavior() {
    }

    public AppBarFlingFixBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean onStartNestedScroll(CoordinatorLayout parent, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes) {
        boolean started;
        boolean bl = started = (nestedScrollAxes & 2) != 0 && child.hasScrollableChildren() && parent.getHeight() - directTargetChild.getHeight() <= child.getHeight();
        if (started && this.mOffsetAnimator != null) {
            this.mOffsetAnimator.cancel();
        }
        this.setLastNestedScrollingChildRef(null);
        return started;
    }

    private void setLastNestedScrollingChildRef(Object o) {
        try {
            Field field = AppBarLayout.Behavior.class.getDeclaredField("mLastNestedScrollingChildRef");
            field.setAccessible(true);
            field.set((Object)this, o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onNestedFling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, float velocityX, float velocityY, boolean consumed) {
        boolean flung = false;
        if (!consumed) {
            flung = this.fling(coordinatorLayout, (View)child, -child.getTotalScrollRange(), 0, -velocityY);
        } else if (velocityY < 0.0f) {
            int targetScroll = child.getDownNestedPreScrollRange();
            this.animateOffsetTo(coordinatorLayout, child, targetScroll, velocityY);
            flung = true;
        } else {
            int targetScroll = -child.getUpNestedPreScrollRange();
            if (this.getTopBottomOffsetForScrollingSibling() > targetScroll) {
                this.animateOffsetTo(coordinatorLayout, child, targetScroll, velocityY);
                flung = true;
            }
        }
        this.setWasNestedFlung(flung);
        return flung;
    }

    private void setWasNestedFlung(boolean o) {
        try {
            Field field = AppBarLayout.Behavior.class.getDeclaredField("mWasNestedFlung");
            field.setAccessible(true);
            field.set((Object)this, o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void animateOffsetTo(CoordinatorLayout coordinatorLayout, AppBarLayout child, int offset, float velocity) {
        int duration;
        int distance = Math.abs(this.getTopBottomOffsetForScrollingSibling() - offset);
        if ((velocity = Math.abs(velocity)) > 0.0f) {
            duration = 3 * Math.round(1000.0f * ((float)distance / velocity));
        } else {
            float distanceRatio = (float)distance / (float)child.getHeight();
            duration = (int)((distanceRatio + 1.0f) * 150.0f);
        }
        this.animateOffsetWithDuration(coordinatorLayout, child, offset, duration);
    }

    private void animateOffsetWithDuration(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, int offset, int duration) {
        int currentOffset = this.getTopBottomOffsetForScrollingSibling();
        if (currentOffset == offset) {
            if (this.mOffsetAnimator != null && this.mOffsetAnimator.isRunning()) {
                this.mOffsetAnimator.cancel();
            }
            return;
        }
        if (this.mOffsetAnimator == null) {
            this.mOffsetAnimator = ViewUtils.createAnimator();
            this.mOffsetAnimator.setInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
            this.mOffsetAnimator.addUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimatorCompat animator) {
                    AppBarFlingFixBehavior.this.setHeaderTopBottomOffset(coordinatorLayout, (View)child, animator.getAnimatedIntValue());
                }
            });
        } else {
            this.mOffsetAnimator.cancel();
        }
        this.mOffsetAnimator.setDuration((long)Math.min(duration, 600));
        this.mOffsetAnimator.setIntValues(currentOffset, offset);
        this.mOffsetAnimator.start();
    }

    @VisibleForTesting
    boolean isOffsetAnimatorRunning() {
        return this.mOffsetAnimator != null && this.mOffsetAnimator.isRunning();
    }
}

