/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.proto.storage.internal;

import com.github.tobato.fastdfs.proto.FdfsRequest;
import com.github.tobato.fastdfs.proto.ProtoHead;
import com.github.tobato.fastdfs.proto.mapper.DynamicFieldType;
import com.github.tobato.fastdfs.proto.mapper.FdfsColumn;
import java.nio.charset.Charset;

public class StorageTruncateRequest
extends FdfsRequest {
    @FdfsColumn(index=0)
    private long pathSize;
    @FdfsColumn(index=1)
    private long fileSize;
    @FdfsColumn(index=2, dynamicField=DynamicFieldType.allRestByte)
    private String path;

    public StorageTruncateRequest(String path, long fileSize) {
        this.fileSize = fileSize;
        this.path = path;
        this.head = new ProtoHead(36);
    }

    @Override
    public byte[] encodeParam(Charset charset) {
        this.pathSize = this.path.getBytes(charset).length;
        return super.encodeParam(charset);
    }

    public long getPathSize() {
        return this.pathSize;
    }

    public void setPathSize(long pathSize) {
        this.pathSize = pathSize;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    public String toString() {
        return "StorageAppendFileRequest [pathSize=" + this.pathSize + ", fileSize=" + this.fileSize + ", path=" + this.path + "]";
    }
}

