/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.BaseAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedAnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBuffer;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.VariableSizeSet;
import java.util.Set;

public class DexBackedAnnotation
extends BaseAnnotation {
    public final DexBackedDexFile dexFile;
    public final int visibility;
    public final int typeIndex;
    private final int elementsOffset;

    public DexBackedAnnotation(DexBackedDexFile dexBackedDexFile, int n) {
        this.dexFile = dexBackedDexFile;
        DexReader<? extends DexBuffer> dexReader = dexBackedDexFile.getDataBuffer().readerAt(n);
        this.visibility = dexReader.readUbyte();
        this.typeIndex = dexReader.readSmallUleb128();
        this.elementsOffset = dexReader.getOffset();
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public String getType() {
        return (String)this.dexFile.getTypeSection().get(this.typeIndex);
    }

    public Set<? extends DexBackedAnnotationElement> getElements() {
        DexReader<? extends DexBuffer> dexReader = this.dexFile.getDataBuffer().readerAt(this.elementsOffset);
        int n = dexReader.readSmallUleb128();
        return new VariableSizeSet<DexBackedAnnotationElement>(this.dexFile.getDataBuffer(), dexReader.getOffset(), n){

            @Override
            protected DexBackedAnnotationElement readNextItem(DexReader dexReader, int n) {
                return new DexBackedAnnotationElement(DexBackedAnnotation.this.dexFile, dexReader);
            }
        };
    }
}

