/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Lists;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.BuilderSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.SwitchLabelElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.builder.instruction.BuilderSwitchElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import java.util.List;

public class BuilderSparseSwitchPayload
extends BuilderSwitchPayload
implements SparseSwitchPayload {
    public static final Opcode OPCODE = Opcode.SPARSE_SWITCH_PAYLOAD;
    protected final List<BuilderSwitchElement> switchElements;

    public BuilderSparseSwitchPayload(List<? extends SwitchLabelElement> list) {
        super(OPCODE);
        this.switchElements = list == null ? ImmutableList.of() : Lists.transform(list, new Function<SwitchLabelElement, BuilderSwitchElement>(){

            @Override
            public BuilderSwitchElement apply(SwitchLabelElement switchLabelElement) {
                assert (switchLabelElement != null);
                return new BuilderSwitchElement(BuilderSparseSwitchPayload.this, switchLabelElement.key, switchLabelElement.target);
            }
        });
    }

    public List<BuilderSwitchElement> getSwitchElements() {
        return this.switchElements;
    }

    @Override
    public int getCodeUnits() {
        return 2 + this.switchElements.size() * 4;
    }

    @Override
    public Format getFormat() {
        return BuilderSparseSwitchPayload.OPCODE.format;
    }
}

