/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.google.common.base;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Function;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Predicate;
import java.io.Serializable;

public final class Predicates {
    private Predicates() {
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new CompositionPredicate(predicate, function);
    }

    private static class CompositionPredicate<A, B>
    implements Predicate<A>,
    Serializable {
        final Predicate<B> p;
        final Function<A, ? extends B> f;

        private CompositionPredicate(Predicate<B> predicate, Function<A, ? extends B> function) {
            this.p = Preconditions.checkNotNull(predicate);
            this.f = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean apply(A a) {
            return this.p.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof CompositionPredicate) {
                CompositionPredicate compositionPredicate = (CompositionPredicate)object;
                return this.f.equals(compositionPredicate.f) && this.p.equals(compositionPredicate.p);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public String toString() {
            return this.p + "(" + this.f + ")";
        }
    }
}

